/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.fmea;

import com.qualidadeeprodutividade.fmea.Dfmea;
import com.qualidadeeprodutividade.fmea.DfmeaRow;
import com.qualidadeeprodutividade.fmea.FmeaExportColors;
import com.qualidadeeprodutividade.pdf.PdfAssets;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class DfmeaExcelExporter {
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final int LOGO_COLUMN_INDEX = 30;
    private static final int LOGO_COLUMN_SPAN = 3;
    private static final int LOGO_ROW_INDEX = 0;
    private static final int LOGO_ROW_SPAN = 5;

    private DfmeaExcelExporter() {
    }

    public static void export(Dfmea model, Path targetPath) throws IOException {
        DfmeaExcelExporter.export(model, targetPath, null);
    }

    public static void export(Dfmea model, Path targetPath, Path logoPath) throws IOException {
        Objects.requireNonNull(model, "DFMEA model is null");
        Objects.requireNonNull(targetPath, "Target path is null");
        if (targetPath.getParent() != null) {
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet("DFMEA");
            sheet.setDisplayGridlines(false);
            sheet.setPrintGridlines(false);
            CellStyle titleStyle = workbook.createCellStyle();
            Font titleFont = workbook.createFont();
            titleFont.setBold(true);
            titleFont.setFontHeightInPoints((short)14);
            titleStyle.setFont(titleFont);
            CellStyle headerStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerStyle.setFont(headerFont);
            headerStyle.setWrapText(true);
            headerStyle.setVerticalAlignment(VerticalAlignment.TOP);
            DfmeaExcelExporter.applyThinBorders(headerStyle);
            DfmeaExcelExporter.applyFill(headerStyle, FmeaExportColors.HEADER_DEFAULT);
            HashMap<Integer, CellStyle> headerStyleCache = new HashMap<Integer, CellStyle>();
            headerStyleCache.put(DfmeaExcelExporter.rgbKey(FmeaExportColors.HEADER_DEFAULT), headerStyle);
            CellStyle keyStyle = workbook.createCellStyle();
            Font keyFont = workbook.createFont();
            keyFont.setBold(true);
            keyStyle.setFont(keyFont);
            keyStyle.setAlignment(HorizontalAlignment.LEFT);
            DfmeaExcelExporter.applyThinBorders(keyStyle);
            CellStyle valueStyle = workbook.createCellStyle();
            valueStyle.setWrapText(true);
            valueStyle.setVerticalAlignment(VerticalAlignment.TOP);
            DfmeaExcelExporter.applyThinBorders(valueStyle);
            CellStyle apHighStyle = DfmeaExcelExporter.createFilledStyle((Workbook)workbook, valueStyle, FmeaExportColors.AP_HIGH, HorizontalAlignment.CENTER);
            CellStyle apMediumStyle = DfmeaExcelExporter.createFilledStyle((Workbook)workbook, valueStyle, FmeaExportColors.AP_MEDIUM, HorizontalAlignment.CENTER);
            CellStyle apLowStyle = DfmeaExcelExporter.createFilledStyle((Workbook)workbook, valueStyle, FmeaExportColors.AP_LOW, HorizontalAlignment.CENTER);
            int rowIdx = 0;
            Row titleRow = sheet.createRow(rowIdx++);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellValue("DFMEA for " + DfmeaExcelExporter.nz(model.getDfmeaSubject(), "DFMEA"));
            titleCell.setCellStyle(titleStyle);
            titleRow.setHeightInPoints(36.0f);
            Row subtitleRow = sheet.createRow(rowIdx++);
            subtitleRow.createCell(0).setCellValue("DFMEA ID: " + DfmeaExcelExporter.nz(model.getDfmeaIdNumber(), "N/A"));
            subtitleRow.createCell(1).setCellValue("Revision: " + DfmeaExcelExporter.nz(DfmeaExcelExporter.resolveRevisionForDisplay(model), "N/A"));
            subtitleRow.createCell(2).setCellValue("Confidentiality: " + (model.getConfidentialityLevel() == null ? "N/A" : model.getConfidentialityLevel().toString()));
            subtitleRow.setHeightInPoints(20.0f);
            ++rowIdx;
            rowIdx = DfmeaExcelExporter.writeHeaderSection(sheet, rowIdx, keyStyle, valueStyle, model);
            rowIdx += 2;
            List<ColumnSpec> columns = DfmeaExcelExporter.buildColumnCatalog();
            Row headerRow = sheet.createRow(rowIdx++);
            for (int i = 0; i < columns.size(); ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(columns.get((int)i).title);
                cell.setCellStyle(DfmeaExcelExporter.headerStyleForTitle((Workbook)workbook, headerStyleCache, headerStyle, columns.get((int)i).title));
            }
            for (DfmeaRow rowModel : DfmeaExcelExporter.safeList(model.getFailureChains())) {
                Row row = sheet.createRow(rowIdx++);
                for (int col = 0; col < columns.size(); ++col) {
                    ColumnSpec spec = columns.get(col);
                    Cell cell = row.createCell(col);
                    cell.setCellValue(DfmeaExcelExporter.readValue(rowModel, spec.getters));
                    if (DfmeaExcelExporter.isApColumn(spec.title)) {
                        DfmeaRow.ActionPriority ap = "Current Action Priority (AP)".equals(spec.title) ? rowModel.getCurrentActionPriority() : rowModel.getActionPriority();
                        Color apColor = FmeaExportColors.apBackgroundForPriority((Object)ap);
                        if (apColor != null) {
                            cell.setCellStyle(DfmeaExcelExporter.apStyleForColor(apColor, apHighStyle, apMediumStyle, apLowStyle));
                            continue;
                        }
                        cell.setCellStyle(valueStyle);
                        continue;
                    }
                    cell.setCellStyle(valueStyle);
                }
            }
            for (int i = 0; i < columns.size(); ++i) {
                sheet.autoSizeColumn(i);
            }
            DfmeaExcelExporter.placeLogo((Workbook)workbook, sheet, logoPath);
            try (OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);){
                workbook.write(out);
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed to export DFMEA Excel", ex);
        }
    }

    private static int writeHeaderSection(Sheet sheet, int rowIdx, CellStyle keyStyle, CellStyle valueStyle, Dfmea model) {
        String[][] rows;
        for (String[] rowValues : rows = new String[][]{{"Company Name", DfmeaExcelExporter.nz(model.getCompanyName(), "-"), "Engineering Location", DfmeaExcelExporter.nz(model.getEngineeringLocation(), "-"), "Customer", DfmeaExcelExporter.nz(model.getCustomerName(), "-")}, {"Model Year/Platform", DfmeaExcelExporter.nz(model.getModelYearPlatform(), "-"), "Subject", DfmeaExcelExporter.nz(model.getDfmeaSubject(), "-"), "Design Responsibility", DfmeaExcelExporter.nz(model.getDesignResponsibility(), "-")}, {"Start Date", DfmeaExcelExporter.formatDate(model.getDfmeaStartDate()), "Last Revision", DfmeaExcelExporter.formatDate(model.getDfmeaLastRevisionDate()), "Core Team", DfmeaExcelExporter.nz(model.getCrossFunctionalTeam(), "-")}, {"DFMEA ID", DfmeaExcelExporter.nz(model.getDfmeaIdNumber(), "-"), "Revision", DfmeaExcelExporter.nz(DfmeaExcelExporter.resolveRevisionForDisplay(model), "-"), "Confidentiality", model.getConfidentialityLevel() == null ? "-" : model.getConfidentialityLevel().toString()}}) {
            Row row = sheet.createRow(rowIdx++);
            for (int i = 0; i < rowValues.length; i += 2) {
                Cell keyCell = row.createCell(i);
                keyCell.setCellValue(rowValues[i]);
                keyCell.setCellStyle(keyStyle);
                Cell valueCell = row.createCell(i + 1);
                valueCell.setCellValue(rowValues[i + 1]);
                valueCell.setCellStyle(valueStyle);
            }
        }
        return rowIdx;
    }

    private static List<ColumnSpec> buildColumnCatalog() {
        ArrayList<ColumnSpec> catalog = new ArrayList<ColumnSpec>();
        catalog.add(new ColumnSpec("Issue Number", "getIssueNumber"));
        catalog.add(new ColumnSpec("History / Change Authorization (as applicable)", "getChangeAuthorization"));
        catalog.add(new ColumnSpec("1. Next Higher Level", "getNextHigherLevelText", "getNextHigherLevel"));
        catalog.add(new ColumnSpec("2. Focus Element", "getFocusElementText", "getFocusElement"));
        catalog.add(new ColumnSpec("3. Next Lower Level or Characteristic", "getNextLowerLevelOrCharacteristicText", "getNextLowerLevelOrCharacteristic"));
        catalog.add(new ColumnSpec("1. Next Higher Level Function and Requirement", "getNextHigherLevelFunction"));
        catalog.add(new ColumnSpec("2. Focus Element Function and Requirement", "getFocusElementFunctionRequirement"));
        catalog.add(new ColumnSpec("3. Characteristics / Function of Next Lower Level Element", "getNextLowerLevelFunctionRequirementOrCharacteristic"));
        catalog.add(new ColumnSpec("1. Failure Effects to the Next Higher Level Element and/or End User", "getFailureEffect"));
        catalog.add(new ColumnSpec("Severity (S) of FE", "getSeverity"));
        catalog.add(new ColumnSpec("2. Failure Mode (FM) of the Focus Element", "getFailureMode"));
        catalog.add(new ColumnSpec("3. Failure Cause (FC) of the Next Lower Level Element or Characteristic", "getFailureCause"));
        catalog.add(new ColumnSpec("Current Prevention Control (PC) of FC", "getPreventionControl"));
        catalog.add(new ColumnSpec("Occurrence (O) of FC", "getOccurrence"));
        catalog.add(new ColumnSpec("Current Detection Controls (DC) of FC or FM", "getDetectionControl"));
        catalog.add(new ColumnSpec("Detection (D) of FC or FM", "getDetection"));
        catalog.add(new ColumnSpec("Action Priority (AP)", "getActionPriority"));
        catalog.add(new ColumnSpec("Filter Code", "getFilterCode"));
        catalog.add(new ColumnSpec("DFMEA Preventive Action", "getPreventiveAction"));
        catalog.add(new ColumnSpec("DFMEA Detection Action", "getDetectionAction"));
        catalog.add(new ColumnSpec("Responsible Person", "getResponsiblePerson"));
        catalog.add(new ColumnSpec("Target Date", "getTargetCompletionDate"));
        catalog.add(new ColumnSpec("Status", "getStatus"));
        catalog.add(new ColumnSpec("Action Taken with Pointer to Evidence", "getActionTakenEvidence"));
        catalog.add(new ColumnSpec("Completion Date", "getCompletionDate"));
        catalog.add(new ColumnSpec("Current Severity (S)", "getCurrentSeverity"));
        catalog.add(new ColumnSpec("Current Occurrence (O)", "getCurrentOccurrence"));
        catalog.add(new ColumnSpec("Current Detection (D)", "getCurrentDetection"));
        catalog.add(new ColumnSpec("Current Action Priority (AP)", "getCurrentActionPriority"));
        catalog.add(new ColumnSpec("Remarks", "getRemarks"));
        return catalog;
    }

    private static void applyThinBorders(CellStyle style) {
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
    }

    private static boolean isApColumn(String title) {
        return "Action Priority (AP)".equals(title) || "Current Action Priority (AP)".equals(title);
    }

    private static CellStyle apStyleForColor(Color apColor, CellStyle high, CellStyle medium, CellStyle low) {
        if (apColor == null) {
            return null;
        }
        int k = DfmeaExcelExporter.rgbKey(apColor);
        if (k == DfmeaExcelExporter.rgbKey(FmeaExportColors.AP_HIGH)) {
            return high;
        }
        if (k == DfmeaExcelExporter.rgbKey(FmeaExportColors.AP_MEDIUM)) {
            return medium;
        }
        if (k == DfmeaExcelExporter.rgbKey(FmeaExportColors.AP_LOW)) {
            return low;
        }
        return null;
    }

    private static CellStyle headerStyleForTitle(Workbook workbook, Map<Integer, CellStyle> cache, CellStyle base, String title) {
        Color group = FmeaExportColors.headerBackgroundForTitle(title);
        Color color = group != null ? group : FmeaExportColors.HEADER_DEFAULT;
        int key = DfmeaExcelExporter.rgbKey(color);
        CellStyle cached = cache.get(key);
        if (cached != null) {
            return cached;
        }
        CellStyle created = workbook.createCellStyle();
        created.cloneStyleFrom(base);
        DfmeaExcelExporter.applyFill(created, color);
        cache.put(key, created);
        return created;
    }

    private static CellStyle createFilledStyle(Workbook workbook, CellStyle base, Color fill, HorizontalAlignment alignment) {
        CellStyle style = workbook.createCellStyle();
        style.cloneStyleFrom(base);
        style.setWrapText(false);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(alignment);
        DfmeaExcelExporter.applyFill(style, fill);
        return style;
    }

    private static void applyFill(CellStyle style, Color fill) {
        if (style == null || fill == null) {
            return;
        }
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
            xssfStyle.setFillForegroundColor(new XSSFColor(fill, (IndexedColorMap)new DefaultIndexedColorMap()));
        }
    }

    private static int rgbKey(Color c) {
        if (c == null) {
            return 0;
        }
        return c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
    }

    private static <T> List<T> safeList(List<T> list) {
        return list == null ? List.of() : list;
    }

    private static String readValue(Object source, String ... getterNames) {
        if (source == null) {
            return "-";
        }
        for (String name : getterNames) {
            try {
                Method method = source.getClass().getMethod(name, new Class[0]);
                Object value = method.invoke(source, new Object[0]);
                if (value == null) continue;
                try {
                    String[] mv = value.getClass().getMethod("getValue", new Class[0]);
                    Object vv = mv.invoke(value, new Object[0]);
                    return vv == null ? "-" : vv.toString();
                }
                catch (NoSuchMethodException mv) {
                    for (String accessor : new String[]{"getActionPriority", "getDfmeaStatus", "getLabel", "getDescription", "getDisplayName"}) {
                        try {
                            String text;
                            Method ma = value.getClass().getMethod(accessor, new Class[0]);
                            Object vv = ma.invoke(value, new Object[0]);
                            if (vv == null || (text = vv.toString()) == null || text.trim().isEmpty()) continue;
                            return text.trim();
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (value instanceof Enum) {
                        return ((Enum)value).name().replace('_', ' ').trim();
                    }
                    if (value instanceof LocalDate) {
                        LocalDate date = (LocalDate)value;
                        return DfmeaExcelExporter.formatDate(date);
                    }
                    String text = value.toString();
                    if (text == null || text.trim().isEmpty()) continue;
                    return text.trim();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "-";
    }

    private static String resolveRevisionForDisplay(Dfmea model) {
        if (model == null) {
            return "";
        }
        return model.latestApprovedRevision().map(entry -> {
            String code = entry.getRevisionNumber();
            return code != null ? code.trim() : "";
        }).filter(code -> !code.isEmpty()).orElseGet(() -> {
            String code = model.getDfmeaRevision();
            return code != null ? code.trim() : "";
        });
    }

    private static String formatDate(LocalDate date) {
        if (date == null) {
            return "-";
        }
        return DATE_FMT.format(date);
    }

    private static String nz(String value, String fallback) {
        if (value == null) {
            return fallback;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? fallback : trimmed;
    }

    private static void placeLogo(Workbook workbook, Sheet sheet, Path logoPath) {
        byte[] logoBytes = PdfAssets.loadLogoBytes(logoPath);
        if (logoBytes == null || logoBytes.length == 0) {
            return;
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(logoBytes));
            if (image == null) {
                return;
            }
            int pictureIdx = workbook.addPicture(logoBytes, 6);
            CreationHelper helper = workbook.getCreationHelper();
            Drawing drawing = sheet.createDrawingPatriarch();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setCol1(30);
            anchor.setRow1(0);
            anchor.setDx1(0);
            anchor.setDy1(0);
            anchor.setCol2(33);
            anchor.setRow2(5);
            anchor.setDx2(0);
            anchor.setDy2(0);
            drawing.createPicture(anchor, pictureIdx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class ColumnSpec {
        final String title;
        final String[] getters;

        ColumnSpec(String title, String ... getters) {
            this.title = title;
            this.getters = getters;
        }
    }
}

