/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.fmea;

import java.awt.Color;

public final class FmeaExportColors {
    public static final Color HEADER_DEFAULT = FmeaExportColors.fromHex("#E6E6E6");
    public static final Color HEADER_GROUP_HIGHER_LEVEL = FmeaExportColors.fromHex("#E0C2CD");
    public static final Color HEADER_GROUP_FOCUS_ELEMENT = FmeaExportColors.fromHex("#729FCF");
    public static final Color HEADER_GROUP_LOWER_LEVEL = FmeaExportColors.fromHex("#8E86AE");
    public static final Color AP_HIGH = FmeaExportColors.fromHex("#F08080");
    public static final Color AP_MEDIUM = FmeaExportColors.fromHex("#F0E68C");
    public static final Color AP_LOW = FmeaExportColors.fromHex("#90EE90");

    private FmeaExportColors() {
    }

    public static Color headerBackgroundForTitle(String title) {
        if (title == null || title.isBlank()) {
            return null;
        }
        String t = title.trim().toLowerCase();
        if (t.contains("prevention control") || t.contains("detection control") || t.contains("detection controls")) {
            return null;
        }
        if (t.contains("next higher level") || t.contains("higher level function") || t.contains("failure effects") || t.contains("failure effect") && !t.contains("mode") && !t.contains("cause")) {
            return HEADER_GROUP_HIGHER_LEVEL;
        }
        if (t.contains("focus element") || t.contains("failure mode")) {
            return HEADER_GROUP_FOCUS_ELEMENT;
        }
        if (t.contains("next lower level") || t.contains("lower level function") || t.contains("failure cause")) {
            return HEADER_GROUP_LOWER_LEVEL;
        }
        return null;
    }

    public static Color apBackgroundForPriority(Object actionPriority) {
        if (actionPriority == null) {
            return null;
        }
        String text = actionPriority.toString();
        if (text == null) {
            return null;
        }
        String normalized = text.trim().toLowerCase();
        if (normalized.isEmpty()) {
            return null;
        }
        char c = normalized.charAt(0);
        return switch (c) {
            case 'h' -> AP_HIGH;
            case 'm' -> AP_MEDIUM;
            case 'l' -> AP_LOW;
            default -> null;
        };
    }

    private static Color fromHex(String hex) {
        if (hex == null) {
            return Color.LIGHT_GRAY;
        }
        String h = hex.trim();
        if (h.startsWith("#")) {
            h = h.substring(1);
        }
        if (h.length() != 6) {
            return Color.LIGHT_GRAY;
        }
        try {
            int rgb = Integer.parseInt(h, 16);
            return new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
        catch (NumberFormatException ex) {
            return Color.LIGHT_GRAY;
        }
    }
}

