/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.fmea;

import com.qualidadeeprodutividade.fmea.ApprovalStatus;
import com.qualidadeeprodutividade.fmea.ConfidentialityLevel;
import com.qualidadeeprodutividade.fmea.PfmeaRow;
import com.qualidadeeprodutividade.fmea.RevisionEntry;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Pfmea {
    private final String uuid = UUID.randomUUID().toString();
    private final StringProperty companyName = new SimpleStringProperty((Object)this, "companyName", "");
    private final StringProperty plantLocation = new SimpleStringProperty((Object)this, "plantLocation", "");
    private final StringProperty customerName = new SimpleStringProperty((Object)this, "customerName", "");
    private final StringProperty modelYearPlatform = new SimpleStringProperty((Object)this, "modelYearPlatform", "");
    private final StringProperty pfmeaSubject = new SimpleStringProperty((Object)this, "pfmeaSubject", "");
    private final ObjectProperty<LocalDate> pfmeaStartDate = new SimpleObjectProperty((Object)this, "pfmeaStartDate", null);
    private final ObjectProperty<LocalDate> pfmeaLastRevisionDate = new SimpleObjectProperty((Object)this, "pfmeaLastRevisionDate", null);
    private final StringProperty crossFunctionalTeam = new SimpleStringProperty((Object)this, "crossFunctionalTeam", "");
    private final StringProperty pfmeaIdNumber = new SimpleStringProperty((Object)this, "pfmeaIdNumber", "");
    private final StringProperty pfmeaRevision = new SimpleStringProperty((Object)this, "pfmeaRevision", "");
    private final StringProperty processResponsibility = new SimpleStringProperty((Object)this, "processResponsibility", "");
    private final ObjectProperty<ConfidentialityLevel> confidentialityLevel = new SimpleObjectProperty((Object)this, "confidentialityLevel", (Object)ConfidentialityLevel.INTERNAL);
    private final ObservableList<RevisionEntry> revisionHistory = FXCollections.observableArrayList();
    private final ObservableList<PfmeaRow> failureChains = FXCollections.observableArrayList();

    public ObservableList<RevisionEntry> getRevisionHistory() {
        return this.revisionHistory;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getCompanyName() {
        return (String)this.companyName.get();
    }

    public void setCompanyName(String value) {
        this.companyName.set((Object)value);
    }

    public StringProperty companyNameProperty() {
        return this.companyName;
    }

    public String getPlantLocation() {
        return (String)this.plantLocation.get();
    }

    public void setPlantLocation(String value) {
        this.plantLocation.set((Object)value);
    }

    public StringProperty plantLocationProperty() {
        return this.plantLocation;
    }

    public String getCustomerName() {
        return (String)this.customerName.get();
    }

    public void setCustomerName(String value) {
        this.customerName.set((Object)value);
    }

    public StringProperty customerNameProperty() {
        return this.customerName;
    }

    public String getModelYearPlatform() {
        return (String)this.modelYearPlatform.get();
    }

    public void setModelYearPlatform(String value) {
        this.modelYearPlatform.set((Object)value);
    }

    public StringProperty modelYearPlatformProperty() {
        return this.modelYearPlatform;
    }

    public String getPfmeaSubject() {
        return (String)this.pfmeaSubject.get();
    }

    public void setPfmeaSubject(String value) {
        this.pfmeaSubject.set((Object)value);
    }

    public StringProperty pfmeaSubjectProperty() {
        return this.pfmeaSubject;
    }

    public LocalDate getPfmeaStartDate() {
        return (LocalDate)this.pfmeaStartDate.get();
    }

    public void setPfmeaStartDate(LocalDate value) {
        this.pfmeaStartDate.set((Object)value);
    }

    public ObjectProperty<LocalDate> pfmeaStartDateProperty() {
        return this.pfmeaStartDate;
    }

    public LocalDate getPfmeaLastRevisionDate() {
        return (LocalDate)this.pfmeaLastRevisionDate.get();
    }

    public void setPfmeaLastRevisionDate(LocalDate value) {
        this.pfmeaLastRevisionDate.set((Object)value);
    }

    public ObjectProperty<LocalDate> pfmeaLastRevisionDateProperty() {
        return this.pfmeaLastRevisionDate;
    }

    public String getCrossFunctionalTeam() {
        return (String)this.crossFunctionalTeam.get();
    }

    public void setCrossFunctionalTeam(String value) {
        this.crossFunctionalTeam.set((Object)value);
    }

    public StringProperty crossFunctionalTeamProperty() {
        return this.crossFunctionalTeam;
    }

    public String getPfmeaIdNumber() {
        return (String)this.pfmeaIdNumber.get();
    }

    public void setPfmeaIdNumber(String value) {
        this.pfmeaIdNumber.set((Object)value);
    }

    public StringProperty pfmeaIdNumberProperty() {
        return this.pfmeaIdNumber;
    }

    public String getPfmeaRevision() {
        return (String)this.pfmeaRevision.get();
    }

    public void setPfmeaRevision(String value) {
        this.pfmeaRevision.set((Object)value);
    }

    public StringProperty pfmeaRevisionProperty() {
        return this.pfmeaRevision;
    }

    public String getProcessResponsibility() {
        return (String)this.processResponsibility.get();
    }

    public void setProcessResponsibility(String value) {
        this.processResponsibility.set((Object)value);
    }

    public StringProperty processResponsibilityProperty() {
        return this.processResponsibility;
    }

    public ConfidentialityLevel getConfidentialityLevel() {
        return (ConfidentialityLevel)((Object)this.confidentialityLevel.get());
    }

    public void setConfidentialityLevel(ConfidentialityLevel level) {
        this.confidentialityLevel.set((Object)level);
    }

    public ObjectProperty<ConfidentialityLevel> confidentialityLevelProperty() {
        return this.confidentialityLevel;
    }

    public ObservableList<PfmeaRow> getFailureChains() {
        return this.failureChains;
    }

    public PfmeaRow addEmptyChain() {
        PfmeaRow row = new PfmeaRow();
        this.failureChains.add((Object)row);
        return row;
    }

    public void addFailureChain(PfmeaRow child) {
        if (child != null) {
            this.failureChains.add((Object)child);
        }
    }

    public boolean removeControlChain(PfmeaRow child) {
        return this.failureChains.remove((Object)child);
    }

    public boolean removeChain(PfmeaRow row) {
        return this.failureChains.remove((Object)row);
    }

    public void clearFailureChains() {
        this.failureChains.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pfmea)) {
            return false;
        }
        Pfmea other = (Pfmea)o;
        return Objects.equals(this.uuid, other.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return this.getPfmeaSubject();
    }

    public RevisionEntry addRevision(RevisionEntry entry) {
        if (entry != null) {
            this.revisionHistory.add((Object)entry);
        }
        return entry;
    }

    public RevisionEntry addRevision(String revisionNumber, LocalDate revisionDate, String authorName, String descriptionOfChanges, ApprovalStatus approvalStatus) {
        RevisionEntry entry = new RevisionEntry(revisionNumber, revisionDate, authorName, descriptionOfChanges, approvalStatus);
        return this.addRevision(entry);
    }

    public boolean removeRevision(RevisionEntry entry) {
        return this.revisionHistory.remove((Object)entry);
    }

    public Optional<RevisionEntry> latestApprovedRevision() {
        return this.revisionHistory.stream().filter(e -> e.getApprovalStatus() == ApprovalStatus.APPROVED).max(Comparator.comparing(e -> e.getRevisionDate() != null ? e.getRevisionDate() : LocalDate.MIN));
    }

    public void approveRevision(RevisionEntry entry) {
        if (entry != null) {
            entry.setApprovalStatus(ApprovalStatus.APPROVED);
        }
    }
}

