/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.fmea;

import com.qualidadeeprodutividade.fmea.FmeaExportColors;
import com.qualidadeeprodutividade.fmea.Pfmea;
import com.qualidadeeprodutividade.fmea.PfmeaRow;
import com.qualidadeeprodutividade.fmea.RevisionEntry;
import com.qualidadeeprodutividade.pdf.PdfAssets;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class PfmeaExcelExporter {
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final int LOGO_COLUMN_INDEX = 25;
    private static final int LOGO_COLUMN_SPAN = 2;
    private static final int LOGO_ROW_INDEX = 0;
    private static final int LOGO_ROW_SPAN = 5;

    private PfmeaExcelExporter() {
    }

    public static void export(Pfmea model, Path targetPath) throws IOException {
        PfmeaExcelExporter.export(model, targetPath, null);
    }

    public static void export(Pfmea model, Path targetPath, Path logoPath) throws IOException {
        Objects.requireNonNull(model, "PFMEA model is null");
        Objects.requireNonNull(targetPath, "Target path is null");
        if (targetPath.getParent() != null) {
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet("PFMEA");
            sheet.setDisplayGridlines(false);
            sheet.setPrintGridlines(false);
            CellStyle titleStyle = workbook.createCellStyle();
            Font titleFont = workbook.createFont();
            titleFont.setBold(true);
            titleFont.setFontHeightInPoints((short)14);
            titleStyle.setFont(titleFont);
            CellStyle headerStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerStyle.setFont(headerFont);
            headerStyle.setWrapText(true);
            headerStyle.setVerticalAlignment(VerticalAlignment.TOP);
            PfmeaExcelExporter.applyThinBorders(headerStyle);
            PfmeaExcelExporter.applyFill(headerStyle, FmeaExportColors.HEADER_DEFAULT);
            HashMap<Integer, CellStyle> headerStyleCache = new HashMap<Integer, CellStyle>();
            headerStyleCache.put(PfmeaExcelExporter.rgbKey(FmeaExportColors.HEADER_DEFAULT), headerStyle);
            CellStyle keyStyle = workbook.createCellStyle();
            Font keyFont = workbook.createFont();
            keyFont.setBold(true);
            keyStyle.setFont(keyFont);
            keyStyle.setAlignment(HorizontalAlignment.LEFT);
            PfmeaExcelExporter.applyThinBorders(keyStyle);
            CellStyle valueStyle = workbook.createCellStyle();
            valueStyle.setWrapText(true);
            valueStyle.setVerticalAlignment(VerticalAlignment.TOP);
            PfmeaExcelExporter.applyThinBorders(valueStyle);
            CellStyle apHighStyle = PfmeaExcelExporter.createFilledStyle((Workbook)workbook, valueStyle, FmeaExportColors.AP_HIGH, HorizontalAlignment.CENTER);
            CellStyle apMediumStyle = PfmeaExcelExporter.createFilledStyle((Workbook)workbook, valueStyle, FmeaExportColors.AP_MEDIUM, HorizontalAlignment.CENTER);
            CellStyle apLowStyle = PfmeaExcelExporter.createFilledStyle((Workbook)workbook, valueStyle, FmeaExportColors.AP_LOW, HorizontalAlignment.CENTER);
            int rowIdx = 0;
            Row titleRow = sheet.createRow(rowIdx++);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellValue("PFMEA for " + PfmeaExcelExporter.nz(model.getPfmeaSubject(), "PFMEA"));
            titleCell.setCellStyle(titleStyle);
            titleRow.setHeightInPoints(36.0f);
            Row subtitleRow = sheet.createRow(rowIdx++);
            subtitleRow.createCell(0).setCellValue("PFMEA ID: " + PfmeaExcelExporter.nz(model.getPfmeaIdNumber(), "N/A"));
            subtitleRow.createCell(1).setCellValue("Revision: " + PfmeaExcelExporter.nz(PfmeaExcelExporter.resolveRevisionForDisplay(model), "N/A"));
            subtitleRow.createCell(2).setCellValue("Confidentiality: " + (model.getConfidentialityLevel() == null ? "N/A" : model.getConfidentialityLevel().toString()));
            subtitleRow.setHeightInPoints(20.0f);
            ++rowIdx;
            rowIdx = PfmeaExcelExporter.writeHeaderSection(sheet, rowIdx, keyStyle, valueStyle, model);
            rowIdx += 2;
            List<ColumnSpec> columns = PfmeaExcelExporter.buildColumnCatalog();
            Row headerRow = sheet.createRow(rowIdx++);
            for (int i = 0; i < columns.size(); ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(columns.get((int)i).title);
                cell.setCellStyle(PfmeaExcelExporter.headerStyleForTitle((Workbook)workbook, headerStyleCache, headerStyle, columns.get((int)i).title));
            }
            for (PfmeaRow pfmeaRow : PfmeaExcelExporter.safeList(model.getFailureChains())) {
                Row row = sheet.createRow(rowIdx++);
                for (int col = 0; col < columns.size(); ++col) {
                    ColumnSpec spec = columns.get(col);
                    Cell cell = row.createCell(col);
                    cell.setCellValue(PfmeaExcelExporter.readValue(pfmeaRow, spec.getters));
                    if (PfmeaExcelExporter.isApColumn(spec.title)) {
                        PfmeaRow.ActionPriority ap = "Current Action Priority (AP)".equals(spec.title) ? pfmeaRow.getCurrentActionPriority() : pfmeaRow.getActionPriority();
                        Color apColor = FmeaExportColors.apBackgroundForPriority((Object)ap);
                        if (apColor != null) {
                            cell.setCellStyle(PfmeaExcelExporter.apStyleForColor(apColor, apHighStyle, apMediumStyle, apLowStyle));
                            continue;
                        }
                        cell.setCellStyle(valueStyle);
                        continue;
                    }
                    cell.setCellStyle(valueStyle);
                }
            }
            for (int i = 0; i < columns.size(); ++i) {
                sheet.autoSizeColumn(i);
            }
            PfmeaExcelExporter.placeLogo((Workbook)workbook, sheet, logoPath);
            try (OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);){
                workbook.write(out);
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed to export PFMEA Excel", ex);
        }
    }

    private static int writeHeaderSection(Sheet sheet, int rowIdx, CellStyle keyStyle, CellStyle valueStyle, Pfmea model) {
        String[][] rows;
        for (String[] rowValues : rows = new String[][]{{"Company Name", PfmeaExcelExporter.nz(model.getCompanyName(), "-"), "Plant Location", PfmeaExcelExporter.nz(model.getPlantLocation(), "-"), "Customer", PfmeaExcelExporter.nz(model.getCustomerName(), "-")}, {"Model Year/Platform", PfmeaExcelExporter.nz(model.getModelYearPlatform(), "-"), "Subject", PfmeaExcelExporter.nz(model.getPfmeaSubject(), "-"), "Process Responsibility", PfmeaExcelExporter.nz(model.getProcessResponsibility(), "-")}, {"Start Date", PfmeaExcelExporter.formatDate(model.getPfmeaStartDate()), "Last Revision", PfmeaExcelExporter.formatDate(model.getPfmeaLastRevisionDate()), "Core Team", PfmeaExcelExporter.nz(model.getCrossFunctionalTeam(), "-")}, {"PFMEA ID", PfmeaExcelExporter.nz(model.getPfmeaIdNumber(), "-"), "Revision", PfmeaExcelExporter.nz(PfmeaExcelExporter.resolveRevisionForDisplay(model), "-"), "Confidentiality", model.getConfidentialityLevel() == null ? "-" : model.getConfidentialityLevel().toString()}}) {
            Row row = sheet.createRow(rowIdx++);
            for (int i = 0; i < rowValues.length; i += 2) {
                Cell keyCell = row.createCell(i);
                keyCell.setCellValue(rowValues[i]);
                keyCell.setCellStyle(keyStyle);
                Cell valueCell = row.createCell(i + 1);
                valueCell.setCellValue(rowValues[i + 1]);
                valueCell.setCellStyle(valueStyle);
            }
        }
        return rowIdx;
    }

    private static List<ColumnSpec> buildColumnCatalog() {
        ArrayList<ColumnSpec> columns = new ArrayList<ColumnSpec>();
        columns.add(new ColumnSpec("Issue Number", "getIssueNumber"));
        columns.add(new ColumnSpec("History / Change Authorization (as applicable)", "getChangeAuthorization"));
        columns.add(new ColumnSpec("1. Next Higher Level", "getNextHigherLevelText", "getNextHigherLevel"));
        columns.add(new ColumnSpec("2. Focus Element", "getFocusElementText", "getFocusElement"));
        columns.add(new ColumnSpec("3. Next Lower Level or Parameter", "getNextLowerLevelOrParameterText", "getNextLowerLevelOrParameter"));
        columns.add(new ColumnSpec("1. Next Higher Level Function and Requirement", "getNextHigherLevelFunction"));
        columns.add(new ColumnSpec("2. Focus Element Function and Requirement", "getFocusElementFunctionRequirement"));
        columns.add(new ColumnSpec("3. Next Lower Level Function and Requirement or Parameter", "getNextLowerLevelFunctionRequirementOrParameter"));
        columns.add(new ColumnSpec("1. Failure Effects to the Next Higher Level Element and/or End User", "getFailureEffect"));
        columns.add(new ColumnSpec("Severity (S)", "getSeverity"));
        columns.add(new ColumnSpec("2. Failure Mode of the Focus Element", "getFailureMode"));
        columns.add(new ColumnSpec("3. Failure Cause of the Next Lower Element or Parameter", "getFailureCause"));
        columns.add(new ColumnSpec("Current Prevention Control of Failure Cause", "getPreventionControl"));
        columns.add(new ColumnSpec("Occurrence (O)", "getOccurrence"));
        columns.add(new ColumnSpec("Current Detection Control of Failure Cause", "getDetectionControl"));
        columns.add(new ColumnSpec("Detection (D)", "getDetection"));
        columns.add(new ColumnSpec("Action Priority (AP)", "getActionPriority"));
        columns.add(new ColumnSpec("Filter Code", "getFilterCode"));
        columns.add(new ColumnSpec("Preventive Action", "getPreventiveAction"));
        columns.add(new ColumnSpec("Detection Action", "getDetectionAction"));
        columns.add(new ColumnSpec("Responsible Person", "getResponsiblePerson"));
        columns.add(new ColumnSpec("Target Completion Date", "getTargetCompletionDate"));
        columns.add(new ColumnSpec("Status", "getStatus"));
        columns.add(new ColumnSpec("Actions Taken", "getActionTakenEvidence"));
        columns.add(new ColumnSpec("Completion Date", "getCompletionDate"));
        columns.add(new ColumnSpec("Current Severity (S)", "getCurrentSeverity"));
        columns.add(new ColumnSpec("Current Occurrence (O)", "getCurrentOccurrence"));
        columns.add(new ColumnSpec("Current Detection (D)", "getCurrentDetection"));
        columns.add(new ColumnSpec("Current Action Priority (AP)", "getCurrentActionPriority"));
        columns.add(new ColumnSpec("Remarks", "getRemarks"));
        return columns;
    }

    private static void applyThinBorders(CellStyle style) {
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
    }

    private static boolean isApColumn(String title) {
        return "Action Priority (AP)".equals(title) || "Current Action Priority (AP)".equals(title);
    }

    private static CellStyle apStyleForColor(Color apColor, CellStyle high, CellStyle medium, CellStyle low) {
        if (apColor == null) {
            return null;
        }
        int k = PfmeaExcelExporter.rgbKey(apColor);
        if (k == PfmeaExcelExporter.rgbKey(FmeaExportColors.AP_HIGH)) {
            return high;
        }
        if (k == PfmeaExcelExporter.rgbKey(FmeaExportColors.AP_MEDIUM)) {
            return medium;
        }
        if (k == PfmeaExcelExporter.rgbKey(FmeaExportColors.AP_LOW)) {
            return low;
        }
        return null;
    }

    private static CellStyle headerStyleForTitle(Workbook workbook, Map<Integer, CellStyle> cache, CellStyle base, String title) {
        Color group = FmeaExportColors.headerBackgroundForTitle(title);
        Color color = group != null ? group : FmeaExportColors.HEADER_DEFAULT;
        int key = PfmeaExcelExporter.rgbKey(color);
        CellStyle cached = cache.get(key);
        if (cached != null) {
            return cached;
        }
        CellStyle created = workbook.createCellStyle();
        created.cloneStyleFrom(base);
        PfmeaExcelExporter.applyFill(created, color);
        cache.put(key, created);
        return created;
    }

    private static CellStyle createFilledStyle(Workbook workbook, CellStyle base, Color fill, HorizontalAlignment alignment) {
        CellStyle style = workbook.createCellStyle();
        style.cloneStyleFrom(base);
        style.setWrapText(false);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(alignment);
        PfmeaExcelExporter.applyFill(style, fill);
        return style;
    }

    private static void applyFill(CellStyle style, Color fill) {
        if (style == null || fill == null) {
            return;
        }
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
            xssfStyle.setFillForegroundColor(new XSSFColor(fill, (IndexedColorMap)new DefaultIndexedColorMap()));
        }
    }

    private static int rgbKey(Color c) {
        if (c == null) {
            return 0;
        }
        return c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
    }

    private static <T> List<T> safeList(List<T> list) {
        return list == null ? List.of() : list;
    }

    private static String readValue(Object source, String ... getterNames) {
        if (source == null) {
            return "-";
        }
        for (String name : getterNames) {
            try {
                Method method = source.getClass().getMethod(name, new Class[0]);
                Object value = method.invoke(source, new Object[0]);
                if (value == null) continue;
                if (value instanceof LocalDate) {
                    LocalDate date = (LocalDate)value;
                    return PfmeaExcelExporter.formatDate(date);
                }
                if (value instanceof PfmeaRow.PfmeaStatus) {
                    PfmeaRow.PfmeaStatus status = (PfmeaRow.PfmeaStatus)((Object)value);
                    return PfmeaExcelExporter.formatStatus(status);
                }
                try {
                    Method mv = value.getClass().getMethod("getValue", new Class[0]);
                    Object vv = mv.invoke(value, new Object[0]);
                    return vv == null ? "-" : vv.toString();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    for (String accessor : new String[]{"getActionPriority", "getPfmeaStatus", "getLabel", "getDescription", "getDisplayName"}) {
                        try {
                            Method ma = value.getClass().getMethod(accessor, new Class[0]);
                            Object vv = ma.invoke(value, new Object[0]);
                            if (vv == null) continue;
                            return vv.toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return value.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "-";
    }

    private static String formatStatus(PfmeaRow.PfmeaStatus status) {
        if (status == null) {
            return "-";
        }
        String raw = status.name().replace('_', ' ').toLowerCase(Locale.ROOT).trim();
        if (raw.isEmpty()) {
            return "-";
        }
        String[] parts = raw.split("\\s+");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() <= 1) continue;
            sb.append(part.substring(1));
        }
        return sb.toString();
    }

    private static String formatDate(LocalDate date) {
        if (date == null) {
            return "-";
        }
        return DATE_FMT.format(date);
    }

    private static String resolveRevisionForDisplay(Pfmea model) {
        if (model == null) {
            return "";
        }
        String revision = model.getPfmeaRevision();
        if (revision != null && !revision.isBlank()) {
            return revision.trim();
        }
        return model.latestApprovedRevision().map(RevisionEntry::getRevisionNumber).map(String::trim).orElse("");
    }

    private static String nz(String value, String fallback) {
        if (value == null) {
            return fallback;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? fallback : trimmed;
    }

    private static void placeLogo(Workbook workbook, Sheet sheet, Path logoPath) {
        byte[] logoBytes = PdfAssets.loadLogoBytes(logoPath);
        if (logoBytes == null || logoBytes.length == 0) {
            return;
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(logoBytes));
            if (image == null) {
                return;
            }
            int pictureIdx = workbook.addPicture(logoBytes, 6);
            CreationHelper helper = workbook.getCreationHelper();
            Drawing drawing = sheet.createDrawingPatriarch();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setCol1(25);
            anchor.setRow1(0);
            anchor.setDx1(0);
            anchor.setDy1(0);
            anchor.setCol2(27);
            anchor.setRow2(5);
            anchor.setDx2(0);
            anchor.setDy2(0);
            drawing.createPicture(anchor, pictureIdx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class ColumnSpec {
        final String title;
        final String[] getters;

        ColumnSpec(String title, String ... getters) {
            this.title = title;
            this.getters = getters;
        }
    }
}

