/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.fmea;

import com.qualidadeeprodutividade.fmea.FmeaExportColors;
import com.qualidadeeprodutividade.fmea.Pfmea;
import com.qualidadeeprodutividade.fmea.PfmeaRow;
import com.qualidadeeprodutividade.pdf.PdfAssets;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openpdf.text.Chunk;
import org.openpdf.text.Document;
import org.openpdf.text.DocumentException;
import org.openpdf.text.Element;
import org.openpdf.text.Font;
import org.openpdf.text.FontFactory;
import org.openpdf.text.Image;
import org.openpdf.text.PageSize;
import org.openpdf.text.Paragraph;
import org.openpdf.text.Phrase;
import org.openpdf.text.SplitCharacter;
import org.openpdf.text.pdf.PdfPCell;
import org.openpdf.text.pdf.PdfPTable;
import org.openpdf.text.pdf.PdfWriter;

public final class PfmeaPdfGenerator {
    private static final float VERTICAL_HEADER_WIDTH = 0.45f;
    private static final Set<String> VERTICAL_HEADERS = Set.of("Severity (S)", "Occurrence (O)", "Detection (D)", "Current Severity (S)", "Current Occurrence (O)", "Current Detection (D)");
    private static final SplitCharacter NO_WORD_BREAK = (start, current, end, chars, chunks) -> {
        if (chars == null || chars.length == 0 || current >= chars.length) {
            return false;
        }
        char c = chars[current];
        return Character.isWhitespace(c);
    };

    private PfmeaPdfGenerator() {
    }

    public static void generatePfmeaPdf(Pfmea model, Path targetPath) throws IOException, DocumentException {
        PfmeaPdfGenerator.generatePfmeaPdf(model, targetPath, null);
    }

    public static void generatePfmeaPdf(Pfmea model, Path targetPath, Path logoPath) throws IOException, DocumentException {
        File parent;
        if (model == null) {
            throw new IllegalArgumentException("PFMEA model is null");
        }
        if (targetPath == null) {
            throw new IllegalArgumentException("Target path is null");
        }
        if (targetPath.getParent() != null && !(parent = targetPath.getParent().toFile()).exists() && !parent.mkdirs()) {
            throw new IllegalStateException("Cannot create directories for " + parent.getAbsolutePath());
        }
        Document document = new Document(PageSize.A2.rotate(), 24.0f, 24.0f, 24.0f, 24.0f);
        try (FileOutputStream out = new FileOutputStream(targetPath.toFile());){
            PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            PfmeaPdfGenerator.addTitleAndMetadata(document, model, logoPath);
            PfmeaPdfGenerator.addHeaderSection(document, model);
            PfmeaPdfGenerator.addRowsSection(document, model);
            document.close();
        }
    }

    private static void addTitleAndMetadata(Document doc, Pfmea model, Path logoPath) throws DocumentException {
        String subject = "PFMEA for " + PfmeaPdfGenerator.nz(model.getPfmeaSubject(), "PFMEA");
        Font titleFont = FontFactory.getFont((String)"Helvetica-Bold", (float)18.0f);
        Paragraph title = new Paragraph(subject, titleFont);
        title.setSpacingAfter(6.0f);
        title.setAlignment(0);
        String subtitleText = "PFMEA ID: " + PfmeaPdfGenerator.nz(model.getPfmeaIdNumber(), "N/A") + "   Rev.: " + PfmeaPdfGenerator.nz(PfmeaPdfGenerator.resolveRevisionForDisplay(model), "N/A") + "   Confidentiality: " + (model.getConfidentialityLevel() == null ? "N/A" : model.getConfidentialityLevel().toString());
        Font subtitleFont = FontFactory.getFont((String)"Helvetica", (float)10.0f);
        Paragraph subtitle = new Paragraph(subtitleText, subtitleFont);
        subtitle.setSpacingAfter(0.0f);
        PdfPTable header = new PdfPTable(new float[]{1.0f, 0.35f});
        header.setWidthPercentage(100.0f);
        PdfPCell textCell = new PdfPCell();
        textCell.setBorder(0);
        textCell.setPadding(0.0f);
        textCell.addElement((Element)title);
        textCell.addElement((Element)subtitle);
        header.addCell(textCell);
        PdfPCell logoCell = new PdfPCell();
        logoCell.setBorder(0);
        logoCell.setPadding(0.0f);
        logoCell.setHorizontalAlignment(2);
        logoCell.setVerticalAlignment(4);
        Image logo = PdfAssets.loadLogo(logoPath);
        if (logo != null) {
            logo.scaleToFit(140.0f, 70.0f);
            logo.setAlignment(2);
            logoCell.addElement((Element)logo);
        }
        header.addCell(logoCell);
        header.setSpacingAfter(10.0f);
        doc.add((Element)header);
    }

    private static void addHeaderSection(Document doc, Pfmea model) throws DocumentException {
        PdfPTable table = new PdfPTable(new float[]{8.0f, 16.0f, 8.0f, 16.0f, 8.0f, 16.0f});
        float headerWidth = PageSize.A3.rotate().getWidth() - doc.leftMargin() - doc.rightMargin();
        table.setTotalWidth(headerWidth);
        table.setLockedWidth(true);
        table.setHorizontalAlignment(0);
        PfmeaPdfGenerator.addHeaderRow(table, "Company Name", PfmeaPdfGenerator.nz(model.getCompanyName(), "-"), "Plant Location", PfmeaPdfGenerator.nz(model.getPlantLocation(), "-"), "Customer", PfmeaPdfGenerator.nz(model.getCustomerName(), "-"));
        PfmeaPdfGenerator.addHeaderRow(table, "Model Year/Platform", PfmeaPdfGenerator.nz(model.getModelYearPlatform(), "-"), "Subject", PfmeaPdfGenerator.nz(model.getPfmeaSubject(), "-"), "Process Responsibility", PfmeaPdfGenerator.nz(model.getProcessResponsibility(), "-"));
        PfmeaPdfGenerator.addHeaderRow(table, "Start Date", PfmeaPdfGenerator.formatDate(model.getPfmeaStartDate()), "Last Revision", PfmeaPdfGenerator.formatDate(model.getPfmeaLastRevisionDate()), "Core Team", PfmeaPdfGenerator.nz(model.getCrossFunctionalTeam(), "-"));
        PfmeaPdfGenerator.addHeaderRow(table, "PFMEA ID", PfmeaPdfGenerator.nz(model.getPfmeaIdNumber(), "-"), "Revision", PfmeaPdfGenerator.nz(PfmeaPdfGenerator.resolveRevisionForDisplay(model), "-"), "Confidentiality", model.getConfidentialityLevel() == null ? "-" : model.getConfidentialityLevel().toString());
        Paragraph caption = new Paragraph("Planning and Preparation", PfmeaPdfGenerator.smallBold());
        caption.setSpacingBefore(4.0f);
        caption.setSpacingAfter(6.0f);
        doc.add((Element)caption);
        doc.add((Element)table);
    }

    private static void addHeaderRow(PdfPTable table, String key1, String value1, String key2, String value2, String key3, String value3) {
        table.addCell(PfmeaPdfGenerator.labelCell(key1));
        table.addCell(PfmeaPdfGenerator.valueCell(value1));
        table.addCell(PfmeaPdfGenerator.labelCell(key2));
        table.addCell(PfmeaPdfGenerator.valueCell(value2));
        table.addCell(PfmeaPdfGenerator.labelCell(key3));
        table.addCell(PfmeaPdfGenerator.valueCell(value3));
    }

    private static void addRowsSection(Document doc, Pfmea model) throws DocumentException {
        List<ColumnSpec> catalog = List.of(new ColumnSpec("Issue Number", 0.9f, "getIssueNumber"), new ColumnSpec("History / Change Authorization (as applicable)", 1.6f, "getChangeAuthorization"), new ColumnSpec("1. Next Higher Level", 1.3f, "getNextHigherLevelText", "getNextHigherLevel"), new ColumnSpec("2. Focus Element", 1.3f, "getFocusElementText", "getFocusElement"), new ColumnSpec("3. Next Lower Level or Parameter", 1.4f, "getNextLowerLevelOrParameterText", "getNextLowerLevelOrParameter"), new ColumnSpec("1. Next Higher Level Function and Requirement", 1.5f, "getNextHigherLevelFunction"), new ColumnSpec("2. Focus Element Function and Requirement", 1.5f, "getFocusElementFunctionRequirement"), new ColumnSpec("3. Next Lower Level Function and Requirement or Parameter", 1.6f, "getNextLowerLevelFunctionRequirementOrParameter"), new ColumnSpec("1. Failure Effects to the Next Higher Level Element and/or End User", 1.7f, "getFailureEffect"), new ColumnSpec("Severity (S)", 0.8f, "getSeverity"), new ColumnSpec("2. Failure Mode of the Focus Element", 1.5f, "getFailureMode"), new ColumnSpec("3. Failure Cause of the Next Lower Element or Parameter", 1.6f, "getFailureCause"), new ColumnSpec("Current Prevention Control of Failure Cause", 1.4f, "getPreventionControl"), new ColumnSpec("Occurrence (O)", 0.8f, "getOccurrence"), new ColumnSpec("Current Detection Control of Failure Cause or Mode", 1.4f, "getDetectionControl"), new ColumnSpec("Detection (D)", 0.8f, "getDetection"), new ColumnSpec("PFMEA Action Priority", 0.9f, "getActionPriority"), new ColumnSpec("RPN", 0.9f, "getRpn"), new ColumnSpec("Filter Code", 0.9f, "getFilterCode"), new ColumnSpec("Preventive Action", 1.3f, "getPreventiveAction"), new ColumnSpec("Detection Action", 1.3f, "getDetectionAction"), new ColumnSpec("Responsible Person", 1.0f, "getResponsiblePerson"), new ColumnSpec("Target Date", 0.9f, "getTargetCompletionDate"), new ColumnSpec("Status", 0.9f, "getStatus"), new ColumnSpec("Action Taken with Pointer to Evidence", 1.6f, "getActionTakenEvidence"), new ColumnSpec("Completion Date", 0.9f, "getCompletionDate"), new ColumnSpec("Current Severity (S)", 0.8f, "getCurrentSeverity"), new ColumnSpec("Current Occurrence (O)", 0.8f, "getCurrentOccurrence"), new ColumnSpec("Current Detection (D)", 0.8f, "getCurrentDetection"), new ColumnSpec("Current Action Priority", 0.9f, "getCurrentActionPriority"), new ColumnSpec("Remarks", 1.2f, "getRemarks"));
        ArrayList<ColumnSpec> active = new ArrayList<ColumnSpec>();
        for (ColumnSpec spec : catalog) {
            if (!PfmeaPdfGenerator.hasAnyData(model.getFailureChains(), spec) && !"RPN".equals(spec.title) && !"PFMEA Action Priority".equals(spec.title)) continue;
            active.add(spec);
        }
        if (active.isEmpty()) {
            Paragraph empty = new Paragraph("No PFMEA rows available.", PfmeaPdfGenerator.small());
            empty.setSpacingBefore(8.0f);
            doc.add((Element)empty);
            return;
        }
        PdfPTable table = new PdfPTable(active.size());
        boolean[] verticalFlags = new boolean[active.size()];
        float[] widths = new float[active.size()];
        float reclaimed = 0.0f;
        int adjustableCount = 0;
        for (int i = 0; i < active.size(); ++i) {
            boolean vertical;
            ColumnSpec spec = (ColumnSpec)active.get(i);
            verticalFlags[i] = vertical = PfmeaPdfGenerator.isVerticalHeader(spec.title);
            if (vertical) {
                widths[i] = 0.45f;
                float diff = spec.weight - 0.45f;
                if (!(diff > 0.0f)) continue;
                reclaimed += diff;
                continue;
            }
            widths[i] = spec.weight;
            ++adjustableCount;
        }
        if (reclaimed > 0.0f && adjustableCount > 0) {
            float bonus = reclaimed / (float)adjustableCount;
            for (int i = 0; i < widths.length; ++i) {
                if (verticalFlags[i]) continue;
                int n = i;
                widths[n] = widths[n] + bonus;
            }
        }
        table.setWidths(widths);
        float availableWidth = doc.getPageSize().getWidth() - doc.leftMargin() - doc.rightMargin();
        table.setTotalWidth(availableWidth);
        table.setLockedWidth(true);
        for (int i = 0; i < active.size(); ++i) {
            ColumnSpec spec = (ColumnSpec)active.get(i);
            PfmeaPdfGenerator.addHeaderCell(table, spec.title, verticalFlags[i]);
        }
        int rowIndex = 0;
        for (PfmeaRow row : model.getFailureChains()) {
            boolean zebra = rowIndex++ % 2 == 1;
            int sev = PfmeaPdfGenerator.readInt(row, "getSeverity");
            int occ = PfmeaPdfGenerator.readInt(row, "getOccurrence");
            int det = PfmeaPdfGenerator.readInt(row, "getDetection");
            for (ColumnSpec c : active) {
                String val;
                if ("RPN".equals(c.title)) {
                    int rpn = sev > 0 && occ > 0 && det > 0 ? sev * occ * det : -1;
                    val = rpn > 0 ? Integer.toString(rpn) : "-";
                } else {
                    val = PfmeaPdfGenerator.readValue(row, c.getters);
                }
                PdfPCell cell = new PdfPCell(PfmeaPdfGenerator.noBreakPhrase(PfmeaPdfGenerator.nz(val, "-"), PfmeaPdfGenerator.small()));
                PfmeaPdfGenerator.styleDataCell(cell, zebra);
                Color apBg = PfmeaPdfGenerator.apBackgroundFor(row, c.title);
                if (apBg != null) {
                    cell.setBackgroundColor(apBg);
                }
                table.addCell(cell);
            }
        }
        Paragraph caption = new Paragraph("Failure Chains", PfmeaPdfGenerator.smallBold());
        caption.setSpacingBefore(10.0f);
        caption.setSpacingAfter(6.0f);
        doc.add((Element)caption);
        doc.add((Element)table);
    }

    private static void addHeaderCell(PdfPTable table, String text, boolean vertical) {
        PdfPCell cell = new PdfPCell(PfmeaPdfGenerator.noBreakPhrase(PfmeaPdfGenerator.nz(text, ""), PfmeaPdfGenerator.smallBold()));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        Color bg = FmeaExportColors.headerBackgroundForTitle(text);
        cell.setBackgroundColor(bg != null ? bg : FmeaExportColors.HEADER_DEFAULT);
        if (vertical) {
            cell.setRotation(90);
            cell.setPadding(6.0f);
        }
        cell.setUseAscender(true);
        cell.setUseDescender(true);
        table.addCell(cell);
    }

    private static PdfPCell labelCell(String text) {
        PdfPCell c = new PdfPCell(PfmeaPdfGenerator.noBreakPhrase(PfmeaPdfGenerator.nz(text, ""), PfmeaPdfGenerator.smallBold()));
        c.setHorizontalAlignment(2);
        c.setVerticalAlignment(5);
        c.setUseAscender(true);
        c.setUseDescender(true);
        return c;
    }

    private static boolean isVerticalHeader(String title) {
        return VERTICAL_HEADERS.contains(title);
    }

    private static PdfPCell valueCell(String text) {
        PdfPCell c = new PdfPCell(PfmeaPdfGenerator.noBreakPhrase(PfmeaPdfGenerator.nz(text, ""), PfmeaPdfGenerator.small()));
        c.setHorizontalAlignment(0);
        c.setVerticalAlignment(5);
        c.setUseAscender(true);
        c.setUseDescender(true);
        return c;
    }

    private static String resolveRevisionForDisplay(Pfmea model) {
        if (model == null) {
            return "";
        }
        return model.latestApprovedRevision().map(entry -> {
            String code = entry.getRevisionNumber();
            return code != null ? code.trim() : "";
        }).filter(code -> !code.isEmpty()).orElseGet(() -> {
            String code = model.getPfmeaRevision();
            return code != null ? code.trim() : "";
        });
    }

    private static String formatDate(LocalDate date) {
        if (date == null) {
            return "-";
        }
        DateTimeFormatter fmt = DateTimeFormatter.ISO_LOCAL_DATE;
        return fmt.format(date);
    }

    private static String nz(String value, String fallback) {
        if (value == null) {
            return fallback;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? fallback : trimmed;
    }

    private static Font small() {
        return FontFactory.getFont((String)"Helvetica", (float)8.0f);
    }

    private static Font smallBold() {
        return FontFactory.getFont((String)"Helvetica-Bold", (float)8.0f);
    }

    private static String readValue(Object source, String ... getterNames) {
        if (source == null) {
            return "-";
        }
        for (String name : getterNames) {
            try {
                PfmeaRow.PfmeaStatus status;
                Method m = source.getClass().getMethod(name, new Class[0]);
                Object v = m.invoke(source, new Object[0]);
                if (v == null) continue;
                if (v instanceof LocalDate) {
                    LocalDate date = (LocalDate)v;
                    return PfmeaPdfGenerator.formatDate(date);
                }
                if (v instanceof PfmeaRow.PfmeaStatus) {
                    status = (PfmeaRow.PfmeaStatus)((Object)v);
                    return PfmeaPdfGenerator.formatStatus(status);
                }
                try {
                    String[] mv = v.getClass().getMethod("getValue", new Class[0]);
                    Object vv = mv.invoke(v, new Object[0]);
                    return vv == null ? "-" : vv.toString();
                }
                catch (NoSuchMethodException mv) {
                    String s;
                    for (String accessor : new String[]{"getActionPriority", "getPfmeaStatus", "getLabel", "getDescription", "getDisplayName"}) {
                        try {
                            String text;
                            Method ma = v.getClass().getMethod(accessor, new Class[0]);
                            Object vv = ma.invoke(v, new Object[0]);
                            if (vv == null || (text = vv.toString()) == null || text.trim().isEmpty()) continue;
                            return text.trim();
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (v instanceof Enum) {
                        if (v instanceof PfmeaRow.PfmeaStatus) {
                            status = (PfmeaRow.PfmeaStatus)((Object)v);
                            return PfmeaPdfGenerator.formatStatus(status);
                        }
                        String enumName = ((Enum)v).name();
                        if (enumName != null && !enumName.isBlank()) {
                            return enumName.replace('_', ' ').trim();
                        }
                    }
                    if ((s = v.toString()) == null || s.trim().isEmpty()) continue;
                    return s.trim();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "-";
    }

    private static int readInt(Object source, String ... getterNames) {
        if (source == null) {
            return -1;
        }
        for (String name : getterNames) {
            try {
                Method m = source.getClass().getMethod(name, new Class[0]);
                Object v = m.invoke(source, new Object[0]);
                if (v == null) continue;
                try {
                    Method mv = v.getClass().getMethod("getValue", new Class[0]);
                    Object vv = mv.invoke(v, new Object[0]);
                    if (vv != null) {
                        return Integer.parseInt(vv.toString());
                    }
                }
                catch (NoSuchMethodException mv) {
                    // empty catch block
                }
                if (v instanceof Number) {
                    Number number = (Number)v;
                    return number.intValue();
                }
                return Integer.parseInt(v.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private static boolean hasAnyData(Iterable<PfmeaRow> rows, ColumnSpec spec) {
        for (PfmeaRow r : rows) {
            if ("-".equals(PfmeaPdfGenerator.readValue(r, spec.getters))) continue;
            return true;
        }
        return false;
    }

    private static void styleDataCell(PdfPCell cell, boolean zebra) {
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setPadding(3.0f);
        cell.setBorderWidth(0.5f);
        cell.setUseAscender(true);
        cell.setUseDescender(true);
        if (zebra) {
            cell.setGrayFill(0.95f);
        }
    }

    private static Color apBackgroundFor(PfmeaRow row, String columnTitle) {
        if (row == null || columnTitle == null) {
            return null;
        }
        return switch (columnTitle) {
            case "PFMEA Action Priority" -> FmeaExportColors.apBackgroundForPriority((Object)row.getActionPriority());
            case "Current Action Priority" -> FmeaExportColors.apBackgroundForPriority((Object)row.getCurrentActionPriority());
            default -> null;
        };
    }

    private static Phrase noBreakPhrase(String value, Font font) {
        Phrase phrase = new Phrase();
        Chunk chunk = new Chunk(value == null ? "" : value, font);
        chunk.setSplitCharacter(NO_WORD_BREAK);
        phrase.add((Element)chunk);
        return phrase;
    }

    private static String formatStatus(PfmeaRow.PfmeaStatus status) {
        if (status == null) {
            return "-";
        }
        return switch (status) {
            default -> throw new MatchException(null, null);
            case PfmeaRow.PfmeaStatus.OPEN -> "Open";
            case PfmeaRow.PfmeaStatus.PENDING_DECISION -> "Pending decision";
            case PfmeaRow.PfmeaStatus.PENDING_IMPLEMENTATION -> "Pending implementation";
            case PfmeaRow.PfmeaStatus.COMPLETED -> "Completed";
            case PfmeaRow.PfmeaStatus.NOT_IMPLEMENTED -> "Not implemented";
        };
    }

    private static final class ColumnSpec {
        final String title;
        final float weight;
        final String[] getters;

        ColumnSpec(String title, float weight, String ... getters) {
            this.title = title;
            this.weight = weight > 0.0f ? weight : 1.0f;
            this.getters = getters;
        }
    }
}

