/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.io;

import com.qualidadeeprodutividade.io.dto.ProjectDTO;
import com.qualidadeeprodutividade.io.mapper.ProjectMapper;
import com.qualidadeeprodutividade.project.Project;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.nio.charset.StandardCharsets;

public final class XmlIO {
    private XmlIO() {
    }

    public static void saveProject(File file, Project project) throws JAXBException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        if (project == null) {
            throw new IllegalArgumentException("project == null");
        }
        ProjectDTO dto = ProjectMapper.toDto(project);
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ProjectDTO.class});
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
        m.marshal((Object)dto, file);
    }

    public static Project openProject(File file) throws JAXBException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("file invalid");
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ProjectDTO.class});
        Unmarshaller u = ctx.createUnmarshaller();
        Object o = u.unmarshal(file);
        if (!(o instanceof ProjectDTO)) {
            throw new JAXBException("Unexpected root element.");
        }
        ProjectDTO dto = (ProjectDTO)o;
        return ProjectMapper.fromDto(dto);
    }
}

