/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.io.mapper;

import com.qualidadeeprodutividade.controlPlan.ControlPlan;
import com.qualidadeeprodutividade.controlPlan.ControlPlanLevel;
import com.qualidadeeprodutividade.controlPlan.ControlPlanRow;
import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.eightd.EightDContainmentAction;
import com.qualidadeeprodutividade.eightd.EightDContainmentInventoryRow;
import com.qualidadeeprodutividade.eightd.EightDCorrectiveAction;
import com.qualidadeeprodutividade.eightd.EightDEffectivenessVerification;
import com.qualidadeeprodutividade.eightd.EightDEvent;
import com.qualidadeeprodutividade.eightd.EightDImage;
import com.qualidadeeprodutividade.eightd.EightDPreventiveAction;
import com.qualidadeeprodutividade.eightd.EightDTeamMember;
import com.qualidadeeprodutividade.fmea.ApprovalStatus;
import com.qualidadeeprodutividade.fmea.ConfidentialityLevel;
import com.qualidadeeprodutividade.fmea.Dfmea;
import com.qualidadeeprodutividade.fmea.DfmeaRow;
import com.qualidadeeprodutividade.fmea.Pfmea;
import com.qualidadeeprodutividade.fmea.PfmeaRow;
import com.qualidadeeprodutividade.fmea.RevisionEntry;
import com.qualidadeeprodutividade.io.dto.ProjectDTO;
import com.qualidadeeprodutividade.item.Characteristic;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.item.ItemType;
import com.qualidadeeprodutividade.item.ProductRequirement;
import com.qualidadeeprodutividade.processItem.Ishikawa;
import com.qualidadeeprodutividade.processItem.Parameter;
import com.qualidadeeprodutividade.processItem.ProcessCategory;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.processItem.ProcessType;
import com.qualidadeeprodutividade.processItem.ValueCategory;
import com.qualidadeeprodutividade.project.Project;
import com.qualidadeeprodutividade.project.ProjectStatus;
import java.util.List;
import java.util.UUID;

public final class ProjectMapper {
    private ProjectMapper() {
    }

    public static ProjectDTO toDto(Project p) {
        ProjectDTO dto = new ProjectDTO();
        dto.id = ProjectMapper.nz(p.getId());
        dto.name = ProjectMapper.nz(p.getName());
        dto.description = ProjectMapper.nz(p.getDescription());
        dto.projectLeader = ProjectMapper.nz(p.getProjectLeader());
        dto.projectTeam = ProjectMapper.nz(p.getProjectTeam());
        dto.startDate = ProjectDTO.toIso(p.getStartDate());
        dto.plant = ProjectMapper.nz(p.getPlant());
        dto.plantLocation = ProjectMapper.nz(p.getPlantLocation());
        dto.status = p.getStatus() == null ? null : p.getStatus().name();
        for (Item it : p.getProductTrees()) {
            dto.productTrees.add(ProjectMapper.itemToDto(it));
        }
        for (ProcessItem pi : p.getProcessTrees()) {
            dto.processTrees.add(ProjectMapper.processItemToDto(pi));
        }
        for (Dfmea d : p.getDfmeas()) {
            dto.dfmeas.add(ProjectMapper.dfmeaToDto(d));
        }
        for (Pfmea f : p.getPfmeas()) {
            dto.pfmeas.add(ProjectMapper.pfmeaToDto(f));
        }
        for (ControlPlan c : p.getControlPlans()) {
            dto.controlPlans.add(ProjectMapper.controlPlanToDto(c));
        }
        for (EightD report : p.getEightDReports()) {
            dto.eightDReports.add(ProjectMapper.eightDToDto(report));
        }
        return dto;
    }

    private static ProjectDTO.ItemDTO itemToDto(Item it) {
        if (it == null) {
            return null;
        }
        ProjectDTO.ItemDTO dto = new ProjectDTO.ItemDTO();
        dto.id = ProjectMapper.nz(it.getId());
        dto.partNumber = ProjectMapper.nz(it.getPartNumber());
        dto.description = ProjectMapper.nz(it.getDescription());
        dto.function = ProjectMapper.nz(it.getFunction());
        dto.type = it.getType() == null ? null : it.getType().name();
        for (Item child : it.getChildren()) {
            dto.children.add(ProjectMapper.itemToDto(child));
        }
        for (Characteristic ch : it.getCharacteristics()) {
            dto.characteristics.add(ProjectMapper.characteristicToDto(ch));
        }
        for (ProductRequirement pr : it.getRequirements()) {
            dto.requirements.add(ProjectMapper.productRequirementToDto(pr));
        }
        return dto;
    }

    private static ProjectDTO.CharacteristicDTO characteristicToDto(Characteristic c) {
        if (c == null) {
            return null;
        }
        ProjectDTO.CharacteristicDTO dto = new ProjectDTO.CharacteristicDTO();
        dto.id = ProjectMapper.nz(c.getId());
        dto.description = ProjectMapper.nz(c.getDescription());
        dto.targetValue = ProjectMapper.nn(c.getTargetValue());
        dto.upperLimit = ProjectMapper.nn(c.getUpperLimit());
        dto.lowerLimit = ProjectMapper.nn(c.getLowerLimit());
        dto.targetValueText = ProjectMapper.blankToNull(c.getTargetValueText());
        dto.upperLimitText = ProjectMapper.blankToNull(c.getUpperLimitText());
        dto.lowerLimitText = ProjectMapper.blankToNull(c.getLowerLimitText());
        dto.cpk = ProjectMapper.nn(c.getCpk());
        dto.cpkText = ProjectMapper.blankToNull(c.getCpkText());
        dto.attribute = c.isAttribute();
        dto.criticalToSafety = c.isCriticalToSafety();
        dto.criticalToQuality = c.isCriticalToQuality();
        dto.criticalToProcess = c.isCriticalToProcess();
        return dto;
    }

    private static ProjectDTO.ProcessItemDTO processItemToDto(ProcessItem pi) {
        if (pi == null) {
            return null;
        }
        ProjectDTO.ProcessItemDTO dto = new ProjectDTO.ProcessItemDTO();
        dto.id = ProjectMapper.nz(pi.getId());
        dto.description = ProjectMapper.nz(pi.getDescription());
        dto.function = ProjectMapper.nz(pi.getFunction());
        dto.time = pi.getTime();
        dto.distance = pi.getDistance();
        dto.category = pi.getCategory() == null ? null : pi.getCategory().name();
        dto.valueCategory = pi.getValueCategory() == null ? null : pi.getValueCategory().name();
        dto.type = pi.getType() == null ? null : pi.getType().name();
        dto.ishikawa = pi.getIshikawa() == null ? null : pi.getIshikawa().name();
        for (ProcessItem child : pi.getChildren()) {
            dto.children.add(ProjectMapper.processItemToDto(child));
        }
        for (Parameter p : pi.getParameters()) {
            dto.parameters.add(ProjectMapper.parameterToDto(p));
        }
        return dto;
    }

    private static ProjectDTO.ParameterDTO parameterToDto(Parameter p) {
        if (p == null) {
            return null;
        }
        ProjectDTO.ParameterDTO dto = new ProjectDTO.ParameterDTO();
        dto.id = ProjectMapper.nz(p.getId());
        dto.description = ProjectMapper.nz(p.getDescription());
        dto.targetValue = ProjectMapper.nn(p.getTargetValue());
        dto.upperLimit = ProjectMapper.nn(p.getUpperLimit());
        dto.lowerLimit = ProjectMapper.nn(p.getLowerLimit());
        dto.targetValueText = ProjectMapper.blankToNull(p.getTargetValueText());
        dto.upperLimitText = ProjectMapper.blankToNull(p.getUpperLimitText());
        dto.lowerLimitText = ProjectMapper.blankToNull(p.getLowerLimitText());
        dto.attribute = p.isAttribute();
        dto.criticalToSafety = p.isCriticalToSafety();
        dto.criticalToQuality = p.isCriticalToQuality();
        dto.criticalToProcess = p.isCriticalToProcess();
        return dto;
    }

    private static ProjectDTO.DfmeaDTO dfmeaToDto(Dfmea d) {
        if (d == null) {
            return null;
        }
        ProjectDTO.DfmeaDTO dto = new ProjectDTO.DfmeaDTO();
        dto.uuid = ProjectMapper.nz(d.getUuid());
        dto.companyName = ProjectMapper.nz(d.getCompanyName());
        dto.engineeringLocation = ProjectMapper.nz(d.getEngineeringLocation());
        dto.productName = ProjectMapper.nz(d.getCustomerName());
        dto.modelYearPlatform = ProjectMapper.nz(d.getModelYearPlatform());
        dto.dfmeaSubject = ProjectMapper.nz(d.getDfmeaSubject());
        dto.dfmeaStartDate = ProjectDTO.toIso(d.getDfmeaStartDate());
        dto.dfmeaLastRevisionDate = ProjectDTO.toIso(d.getDfmeaLastRevisionDate());
        dto.crossFunctionalTeam = ProjectMapper.nz(d.getCrossFunctionalTeam());
        dto.dfmeaIdNumber = ProjectMapper.nz(d.getDfmeaIdNumber());
        dto.dfmeaRevision = ProjectMapper.nz(d.getDfmeaRevision());
        dto.designResponsibility = ProjectMapper.nz(d.getDesignResponsibility());
        String string = dto.confidentialityLevel = d.getConfidentialityLevel() == null ? null : d.getConfidentialityLevel().name();
        if (d.getRevisionHistory() != null) {
            for (RevisionEntry e : d.getRevisionHistory()) {
                ProjectDTO.FmeaRevisionDTO r = new ProjectDTO.FmeaRevisionDTO();
                r.revisionNumber = e.getRevisionNumber();
                r.revisionDate = ProjectDTO.toIso(e.getRevisionDate());
                r.author = e.getAuthorName();
                r.descriptionOfChanges = e.getDescriptionOfChanges();
                r.approvalStatus = e.getApprovalStatus() == null ? null : e.getApprovalStatus().name();
                dto.revisions.add(r);
            }
        }
        for (DfmeaRow r : d.getFailureChains()) {
            dto.failureChains.add(ProjectMapper.dfmeaRowToDto(r));
        }
        return dto;
    }

    private static ProjectDTO.DfmeaRowDTO dfmeaRowToDto(DfmeaRow r) {
        if (r == null) {
            return null;
        }
        ProjectDTO.DfmeaRowDTO dto = new ProjectDTO.DfmeaRowDTO();
        dto.id = ProjectMapper.nz(r.getId() == null ? null : r.getId().toString());
        dto.issueNumber = r.getIssueNumber();
        dto.changeAuthorization = ProjectMapper.nz(r.getChangeAuthorization());
        dto.nextHigherLevel = ProjectMapper.itemToDto(r.getNextHigherLevel());
        dto.focusElement = ProjectMapper.itemToDto(r.getFocusElement());
        dto.nextHigherLevelText = ProjectMapper.nz(r.getNextHigherLevelText());
        dto.focusElementText = ProjectMapper.nz(r.getFocusElementText());
        dto.nextLowerLevelOrCharacteristicText = ProjectMapper.nz(r.getNextLowerLevelOrCharacteristicText());
        Object nlc = r.getNextLowerLevelOrCharacteristic();
        if (nlc != null) {
            ProjectDTO.NextLowerLevelOrCharacteristicDTO wrap = new ProjectDTO.NextLowerLevelOrCharacteristicDTO();
            if (nlc instanceof Item) {
                wrap.item = ProjectMapper.itemToDto((Item)nlc);
            } else if (nlc instanceof Characteristic) {
                wrap.characteristic = ProjectMapper.characteristicToDto((Characteristic)nlc);
            }
            dto.nextLowerLevelOrCharacteristic = wrap;
        }
        dto.nextHigherLevelFunction = ProjectMapper.nz(r.getNextHigherLevelFunction());
        dto.focusElementFunctionRequirement = ProjectMapper.nz(r.getFocusElementFunctionRequirement());
        dto.nextLowerLevelFunctionRequirementOrCharacteristic = ProjectMapper.nz(r.getNextLowerLevelFunctionRequirementOrCharacteristic());
        dto.failureEffect = ProjectMapper.nz(r.getFailureEffect());
        dto.severity = r.getSeverity() == null ? null : r.getSeverity().name();
        dto.failureMode = ProjectMapper.nz(r.getFailureMode());
        dto.failureCause = ProjectMapper.nz(r.getFailureCause());
        dto.preventionControl = ProjectMapper.nz(r.getPreventionControl());
        dto.occurrence = r.getOccurrence() == null ? null : r.getOccurrence().name();
        dto.detectionControl = ProjectMapper.nz(r.getDetectionControl());
        dto.detection = r.getDetection() == null ? null : r.getDetection().name();
        dto.actionPriority = r.getActionPriority() == null ? null : r.getActionPriority().name();
        dto.remarks = ProjectMapper.nz(r.getRemarks());
        dto.filterCode = ProjectMapper.nz(r.getFilterCode());
        dto.preventiveAction = ProjectMapper.nz(r.getPreventiveAction());
        dto.detectionAction = ProjectMapper.nz(r.getDetectionAction());
        dto.responsiblePerson = ProjectMapper.nz(r.getResponsiblePerson());
        dto.targetCompletionDate = ProjectDTO.toIso(r.getTargetCompletionDate());
        dto.status = r.getStatus() == null ? null : r.getStatus().name();
        dto.actionTakenEvidence = ProjectMapper.nz(r.getActionTakenEvidence());
        dto.completionDate = ProjectDTO.toIso(r.getCompletionDate());
        dto.currentSeverity = r.getCurrentSeverity() == null ? null : r.getCurrentSeverity().name();
        dto.currentOccurrence = r.getCurrentOccurrence() == null ? null : r.getCurrentOccurrence().name();
        dto.currentDetection = r.getCurrentDetection() == null ? null : r.getCurrentDetection().name();
        dto.currentActionPriority = r.getCurrentActionPriority() == null ? null : r.getCurrentActionPriority().name();
        return dto;
    }

    private static ProjectDTO.PfmeaDTO pfmeaToDto(Pfmea d) {
        if (d == null) {
            return null;
        }
        ProjectDTO.PfmeaDTO dto = new ProjectDTO.PfmeaDTO();
        dto.uuid = ProjectMapper.nz(d.getUuid());
        dto.companyName = ProjectMapper.nz(d.getCompanyName());
        dto.plantLocation = ProjectMapper.nz(d.getPlantLocation());
        dto.customerName = ProjectMapper.nz(d.getCustomerName());
        dto.modelYearPlatform = ProjectMapper.nz(d.getModelYearPlatform());
        dto.pfmeaSubject = ProjectMapper.nz(d.getPfmeaSubject());
        dto.pfmeaStartDate = ProjectDTO.toIso(d.getPfmeaStartDate());
        dto.pfmeaLastRevisionDate = ProjectDTO.toIso(d.getPfmeaLastRevisionDate());
        dto.crossFunctionalTeam = ProjectMapper.nz(d.getCrossFunctionalTeam());
        dto.pfmeaIdNumber = ProjectMapper.nz(d.getPfmeaIdNumber());
        dto.pfmeaRevision = ProjectMapper.nz(d.getPfmeaRevision());
        dto.processResponsibility = ProjectMapper.nz(d.getProcessResponsibility());
        String string = dto.confidentialityLevel = d.getConfidentialityLevel() == null ? null : d.getConfidentialityLevel().name();
        if (d.getRevisionHistory() != null) {
            for (RevisionEntry e : d.getRevisionHistory()) {
                ProjectDTO.FmeaRevisionDTO r = new ProjectDTO.FmeaRevisionDTO();
                r.revisionNumber = e.getRevisionNumber();
                r.revisionDate = ProjectDTO.toIso(e.getRevisionDate());
                r.author = e.getAuthorName();
                r.descriptionOfChanges = e.getDescriptionOfChanges();
                r.approvalStatus = e.getApprovalStatus() == null ? null : e.getApprovalStatus().name();
                dto.revisions.add(r);
            }
        }
        for (PfmeaRow r : d.getFailureChains()) {
            dto.failureChains.add(ProjectMapper.pfmeaRowToDto(r));
        }
        return dto;
    }

    private static ProjectDTO.PfmeaRowDTO pfmeaRowToDto(PfmeaRow r) {
        if (r == null) {
            return null;
        }
        ProjectDTO.PfmeaRowDTO dto = new ProjectDTO.PfmeaRowDTO();
        dto.id = ProjectMapper.nz(r.getId() == null ? null : r.getId().toString());
        dto.issueNumber = r.getIssueNumber();
        dto.changeAuthorization = ProjectMapper.nz(r.getChangeAuthorization());
        dto.nextHigherLevel = ProjectMapper.processItemToDto(r.getNextHigherLevel());
        dto.focusElement = ProjectMapper.processItemToDto(r.getFocusElement());
        dto.nextHigherLevelText = ProjectMapper.nz(r.getNextHigherLevelText());
        dto.focusElementText = ProjectMapper.nz(r.getFocusElementText());
        dto.nextLowerLevelOrParameterText = ProjectMapper.nz(r.getNextLowerLevelOrParameterText());
        Object lower = r.getNextLowerLevelOrParameter();
        if (lower != null) {
            ProjectDTO.NextLowerLevelOrParameterDTO wrap = new ProjectDTO.NextLowerLevelOrParameterDTO();
            if (lower instanceof ProcessItem) {
                ProcessItem processItem = (ProcessItem)lower;
                wrap.processItem = ProjectMapper.processItemToDto(processItem);
            } else if (lower instanceof Parameter) {
                Parameter parameter = (Parameter)lower;
                wrap.parameter = ProjectMapper.parameterToDto(parameter);
            }
            dto.nextLowerLevelOrParameter = wrap;
        }
        dto.nextHigherLevelFunction = ProjectMapper.nz(r.getNextHigherLevelFunction());
        dto.focusElementFunctionRequirement = ProjectMapper.nz(r.getFocusElementFunctionRequirement());
        dto.nextLowerLevelFunctionRequirementOrParameter = ProjectMapper.nz(r.getNextLowerLevelFunctionRequirementOrParameter());
        dto.failureEffect = ProjectMapper.nz(r.getFailureEffect());
        dto.severity = r.getSeverity() == null ? null : r.getSeverity().name();
        dto.failureMode = ProjectMapper.nz(r.getFailureMode());
        dto.failureCause = ProjectMapper.nz(r.getFailureCause());
        dto.preventionControl = ProjectMapper.nz(r.getPreventionControl());
        dto.occurrence = r.getOccurrence() == null ? null : r.getOccurrence().name();
        dto.detectionControl = ProjectMapper.nz(r.getDetectionControl());
        dto.detection = r.getDetection() == null ? null : r.getDetection().name();
        dto.actionPriority = r.getActionPriority() == null ? null : r.getActionPriority().name();
        dto.remarks = ProjectMapper.nz(r.getRemarks());
        dto.filterCode = ProjectMapper.nz(r.getFilterCode());
        dto.preventiveAction = ProjectMapper.nz(r.getPreventiveAction());
        dto.detectionAction = ProjectMapper.nz(r.getDetectionAction());
        dto.responsiblePerson = ProjectMapper.nz(r.getResponsiblePerson());
        dto.targetCompletionDate = ProjectDTO.toIso(r.getTargetCompletionDate());
        dto.status = r.getStatus() == null ? null : r.getStatus().name();
        dto.actionTakenEvidence = ProjectMapper.nz(r.getActionTakenEvidence());
        dto.completionDate = ProjectDTO.toIso(r.getCompletionDate());
        dto.currentSeverity = r.getCurrentSeverity() == null ? null : r.getCurrentSeverity().name();
        dto.currentOccurrence = r.getCurrentOccurrence() == null ? null : r.getCurrentOccurrence().name();
        dto.currentDetection = r.getCurrentDetection() == null ? null : r.getCurrentDetection().name();
        dto.currentActionPriority = r.getCurrentActionPriority() == null ? null : r.getCurrentActionPriority().name();
        return dto;
    }

    private static ProjectDTO.ControlPlanDTO controlPlanToDto(ControlPlan c) {
        if (c == null) {
            return null;
        }
        ProjectDTO.ControlPlanDTO dto = new ProjectDTO.ControlPlanDTO();
        dto.uuid = ProjectMapper.nz(c.getUuid());
        dto.cpNumber = ProjectMapper.nz(c.getCpNumber());
        dto.cpKeyContact = ProjectMapper.nz(c.getCpKeyContact());
        dto.cpCustomerEngApproval = ProjectMapper.nz(c.getCpCustomerEngApproval());
        dto.cpCustomerQualApproval = ProjectMapper.nz(c.getCpCustomerQualApproval());
        dto.cpCustomerOtherApproval = ProjectMapper.nz(c.getCpCustomerOtherApproval());
        dto.cpSupplierPlantApproval = ProjectMapper.nz(c.getCpSupplierPlantApproval());
        dto.cpSupplierOtherApproval = ProjectMapper.nz(c.getCpSupplierOtherApproval());
        dto.cpStartDate = ProjectDTO.toIso(c.getCpStartDate());
        dto.cpRevisionDate = ProjectDTO.toIso(c.getCpRevisionDate());
        dto.cpRevision = ProjectMapper.nz(c.getCpRevision());
        dto.cpLevel = c.getCpLevel() == null ? null : c.getCpLevel().name();
        dto.cpPartNumber = ProjectMapper.nz(c.getCpPartNumber());
        dto.cpPartName = ProjectMapper.nz(c.getCpPartName());
        dto.crossFunctionalTeam = ProjectMapper.nz(c.getCrossFunctionalTeam());
        dto.supplierPlant = ProjectMapper.nz(c.getSupplierPlant());
        dto.supplierCode = ProjectMapper.nz(c.getSupplierCode());
        dto.revisions.clear();
        for (RevisionEntry rev : c.getRevisionHistory()) {
            ProjectDTO.FmeaRevisionDTO r = new ProjectDTO.FmeaRevisionDTO();
            r.revisionNumber = ProjectMapper.nz(rev.getRevisionNumber());
            r.revisionDate = ProjectDTO.toIso(rev.getRevisionDate());
            r.author = ProjectMapper.nz(rev.getAuthorName());
            r.descriptionOfChanges = ProjectMapper.nz(rev.getDescriptionOfChanges());
            r.approvalStatus = rev.getApprovalStatus() == null ? null : rev.getApprovalStatus().name();
            dto.revisions.add(r);
        }
        for (ControlPlanRow r : c.getControlChains()) {
            dto.controlChains.add(ProjectMapper.controlPlanRowToDto(r));
        }
        return dto;
    }

    private static ProjectDTO.ControlPlanRowDTO controlPlanRowToDto(ControlPlanRow r) {
        if (r == null) {
            return null;
        }
        ProjectDTO.ControlPlanRowDTO dto = new ProjectDTO.ControlPlanRowDTO();
        dto.id = ProjectMapper.nz(r.getId() == null ? null : r.getId().toString());
        dto.partOrProcessNumber = ProjectMapper.nz(r.getPartOrProcessNumber());
        dto.processNameOrOperationDescription = ProjectMapper.nz(r.getProcessNameOrOperationDescription());
        dto.machineDeviceJigToolForMfg = ProjectMapper.nz(r.getMachineDeviceJigToolForMfg());
        dto.Number = ProjectMapper.nz(r.getNumber());
        dto.CharacteristicOrParameter = ProjectMapper.nz(r.getCharacteristicOrParameter());
        dto.productCharacteristic = ProjectMapper.nz(r.getProductCharacteristic());
        dto.processCharacteristic = ProjectMapper.nz(r.getProcessCharacteristic());
        dto.isCriticalToQuality = r.getIsCriticalToQuality();
        dto.isCriticalToSafety = r.getIsCriticalToSafety();
        dto.isCriticalToProcess = r.getIsCriticalToProcess();
        dto.attribute = r.getAttribute();
        dto.targetValue = ProjectMapper.nz(r.getTargetValue());
        dto.upperLimit = ProjectMapper.nz(r.getUpperLimit());
        dto.lowerLimit = ProjectMapper.nz(r.getLowerLimit());
        dto.evaluationMeasurementTechnique = ProjectMapper.nz(r.getEvaluationMeasurementTechnique());
        dto.sampleSize = ProjectMapper.nz(r.getSampleSize());
        dto.sampleFrequency = ProjectMapper.nz(r.getSampleFrequency());
        dto.controlMethod = ProjectMapper.nz(r.getControlMethod());
        dto.reactionPlan = ProjectMapper.nz(r.getReactionPlan());
        return dto;
    }

    private static ProjectDTO.EightDDTO eightDToDto(EightD report) {
        if (report == null) {
            return null;
        }
        ProjectDTO.EightDDTO dto = new ProjectDTO.EightDDTO();
        dto.uuid = ProjectMapper.nz(report.getUuid());
        dto.dateOpened = ProjectDTO.toIso(report.getDateOpened());
        dto.dateRevised = ProjectDTO.toIso(report.getDateRevised());
        dto.closedDate = ProjectDTO.toIso(report.getClosedDate());
        dto.containmentDueDate = ProjectDTO.toIso(report.getContainmentDueDate());
        dto.status = ProjectMapper.nz(report.getStatus());
        dto.customer = ProjectMapper.nz(report.getCustomer());
        dto.customerClaimNumber = ProjectMapper.nz(report.getCustomerClaimNumber());
        dto.internalClaimNumber = ProjectMapper.nz(report.getInternalClaimNumber());
        dto.internalContact = ProjectMapper.nz(report.getInternalContact());
        dto.customerContact = ProjectMapper.nz(report.getCustomerContact());
        dto.partNumber = ProjectMapper.nz(report.getPartNumber());
        dto.partDescription = ProjectMapper.nz(report.getPartDescription());
        dto.quantity = ProjectMapper.nz(report.getQuantity());
        dto.nonConformanceNotification = ProjectMapper.nz(report.getNonConformanceNotification());
        dto.problemDescription = ProjectMapper.nz(report.getProblemDescription());
        dto.d2IsWhat = ProjectMapper.nz(report.getD2IsWhat());
        dto.d2IsNotWhat = ProjectMapper.nz(report.getD2IsNotWhat());
        dto.d2IsWhere = ProjectMapper.nz(report.getD2IsWhere());
        dto.d2IsNotWhere = ProjectMapper.nz(report.getD2IsNotWhere());
        dto.d2IsWhen = ProjectMapper.nz(report.getD2IsWhen());
        dto.d2IsNotWhen = ProjectMapper.nz(report.getD2IsNotWhen());
        dto.d2IsHowMany = ProjectMapper.nz(report.getD2IsHowMany());
        dto.d2IsNotHowMany = ProjectMapper.nz(report.getD2IsNotHowMany());
        dto.d2WhatContrast = report.isD2WhatContrast();
        dto.d2WhereContrast = report.isD2WhereContrast();
        dto.d2WhenContrast = report.isD2WhenContrast();
        dto.d2HowManyContrast = report.isD2HowManyContrast();
        dto.d2DiffContrast1 = ProjectMapper.nz(report.getD2DiffContrast1());
        dto.d2DiffChange1 = ProjectMapper.nz(report.getD2DiffChange1());
        dto.d2DiffContrast2 = ProjectMapper.nz(report.getD2DiffContrast2());
        dto.d2DiffChange2 = ProjectMapper.nz(report.getD2DiffChange2());
        dto.d2DiffContrast3 = ProjectMapper.nz(report.getD2DiffContrast3());
        dto.d2DiffChange3 = ProjectMapper.nz(report.getD2DiffChange3());
        dto.d2DiffContrast4 = ProjectMapper.nz(report.getD2DiffContrast4());
        dto.d2DiffChange4 = ProjectMapper.nz(report.getD2DiffChange4());
        dto.d3ContainmentChampion = ProjectMapper.nz(report.getD3ContainmentChampion());
        dto.d3ContainmentIssueNumber = ProjectMapper.nz(report.getD3ContainmentIssueNumber());
        dto.d3ContainmentDate = ProjectDTO.toIso(report.getD3ContainmentDate());
        dto.d3ContainmentProductName = ProjectMapper.nz(report.getD3ContainmentProductName());
        dto.d3ContainmentPartNumber = ProjectMapper.nz(report.getD3ContainmentPartNumber());
        dto.d3ContainmentProductNonconformance = ProjectMapper.nz(report.getD3ContainmentProductNonconformance());
        dto.d3ContainmentInstructions = ProjectMapper.nz(report.getD3ContainmentInstructions());
        dto.d3ContainmentSegregateTo = ProjectMapper.nz(report.getD3ContainmentSegregateTo());
        dto.d3ContainmentIdentificationConforming = ProjectMapper.nz(report.getD3ContainmentIdentificationConforming());
        dto.d3ContainmentIdentificationNonConforming = ProjectMapper.nz(report.getD3ContainmentIdentificationNonConforming());
        dto.d3ContainmentQualityManager = ProjectMapper.nz(report.getD3ContainmentQualityManager());
        dto.d3ContainmentQualityManagerDate = ProjectDTO.toIso(report.getD3ContainmentQualityManagerDate());
        dto.d8SubmittedBy = ProjectMapper.nz(report.getD8SubmittedBy());
        dto.d8SubmissionDate = ProjectDTO.toIso(report.getD8SubmissionDate());
        dto.d8InternalQualityRepresentative = ProjectMapper.nz(report.getD8InternalQualityRepresentative());
        dto.d8InternalQualityApprovalDate = ProjectDTO.toIso(report.getD8InternalQualityApprovalDate());
        dto.d8InternalRepresentative1 = ProjectMapper.nz(report.getD8InternalRepresentative1());
        dto.d8InternalRepresentative1ApprovalDate = ProjectDTO.toIso(report.getD8InternalRepresentative1ApprovalDate());
        dto.d8InternalRepresentative2 = ProjectMapper.nz(report.getD8InternalRepresentative2());
        dto.d8InternalRepresentative2ApprovalDate = ProjectDTO.toIso(report.getD8InternalRepresentative2ApprovalDate());
        ProjectMapper.copyStringList(report.getPossibleCausesMethod(), dto.possibleCausesMethod);
        ProjectMapper.copyStringList(report.getPossibleCausesMachine(), dto.possibleCausesMachine);
        ProjectMapper.copyStringList(report.getPossibleCausesMaterial(), dto.possibleCausesMaterial);
        ProjectMapper.copyStringList(report.getPossibleCausesManpower(), dto.possibleCausesManpower);
        dto.ishikawaFailureDescription = ProjectMapper.nz(report.getIshikawaFailureDescription());
        ProjectMapper.copyStringList(report.getIshikawaCausesMethod(), dto.ishikawaCausesMethod);
        ProjectMapper.copyStringList(report.getIshikawaCausesMachine(), dto.ishikawaCausesMachine);
        ProjectMapper.copyStringList(report.getIshikawaCausesMeasurements(), dto.ishikawaCausesMeasurements);
        ProjectMapper.copyStringList(report.getIshikawaCausesEnvironment(), dto.ishikawaCausesEnvironment);
        ProjectMapper.copyStringList(report.getIshikawaCausesMaterial(), dto.ishikawaCausesMaterial);
        ProjectMapper.copyStringList(report.getIshikawaCausesManpower(), dto.ishikawaCausesManpower);
        dto.fiveWhysFailureDescription = ProjectMapper.nz(report.getFiveWhysFailureDescription());
        dto.fiveWhysProposedActions = ProjectMapper.nz(report.getFiveWhysProposedActions());
        ProjectMapper.copyStringList(report.getFiveWhysWhy(), dto.fiveWhysQuestions);
        ProjectMapper.copyStringList(report.getFiveWhysAnswers(), dto.fiveWhysAnswers);
        if (report.getContainmentActions() != null) {
            for (Object action : report.getContainmentActions()) {
                dto.containmentActions.add(ProjectMapper.eightDContainmentActionToDto((EightDContainmentAction)action));
            }
        }
        if (report.getCorrectiveActions() != null) {
            for (Object action : report.getCorrectiveActions()) {
                dto.correctiveActions.add(ProjectMapper.eightDCorrectiveActionToDto((EightDCorrectiveAction)action));
            }
        }
        if (report.getEffectivenessVerifications() != null) {
            for (EightDEffectivenessVerification verification : report.getEffectivenessVerifications()) {
                dto.effectivenessVerifications.add(ProjectMapper.eightDEffectivenessVerificationToDto(verification));
            }
        }
        if (report.getPreventiveActions() != null) {
            for (Object action : report.getPreventiveActions()) {
                dto.preventiveActions.add(ProjectMapper.eightDPreventiveActionToDto((EightDPreventiveAction)action));
            }
        }
        dto.d7DesignFmeaChecked = report.isD7DesignFmeaChecked();
        dto.d7DesignFmeaDate = ProjectDTO.toIso(report.getD7DesignFmeaDate());
        dto.d7ProcessFmeaChecked = report.isD7ProcessFmeaChecked();
        dto.d7ProcessFmeaDate = ProjectDTO.toIso(report.getD7ProcessFmeaDate());
        dto.d7ControlPlansChecked = report.isD7ControlPlansChecked();
        dto.d7ControlPlansDate = ProjectDTO.toIso(report.getD7ControlPlansDate());
        dto.d7GageDrawingChecked = report.isD7GageDrawingChecked();
        dto.d7GageDrawingDate = ProjectDTO.toIso(report.getD7GageDrawingDate());
        dto.d7ProcessFlowChecked = report.isD7ProcessFlowChecked();
        dto.d7ProcessFlowDate = ProjectDTO.toIso(report.getD7ProcessFlowDate());
        dto.d7WorkInstructionsChecked = report.isD7WorkInstructionsChecked();
        dto.d7WorkInstructionsDate = ProjectDTO.toIso(report.getD7WorkInstructionsDate());
        dto.d7DrawingChecked = report.isD7DrawingChecked();
        dto.d7DrawingDate = ProjectDTO.toIso(report.getD7DrawingDate());
        dto.d7DesignStandardsChecked = report.isD7DesignStandardsChecked();
        dto.d7DesignStandardsDate = ProjectDTO.toIso(report.getD7DesignStandardsDate());
        dto.d7PackingSpecsChecked = report.isD7PackingSpecsChecked();
        dto.d7PackingSpecsDate = ProjectDTO.toIso(report.getD7PackingSpecsDate());
        dto.d7InternalAuditChecked = report.isD7InternalAuditChecked();
        dto.d7InternalAuditDate = ProjectDTO.toIso(report.getD7InternalAuditDate());
        dto.d7ToolingDrawingChecked = report.isD7ToolingDrawingChecked();
        dto.d7ToolingDrawingDate = ProjectDTO.toIso(report.getD7ToolingDrawingDate());
        dto.d7OperatorTrainingChecked = report.isD7OperatorTrainingChecked();
        dto.d7OperatorTrainingDate = ProjectDTO.toIso(report.getD7OperatorTrainingDate());
        if (report.getTeamMembers() != null) {
            for (EightDTeamMember member : report.getTeamMembers()) {
                dto.teamMembers.add(ProjectMapper.eightDTeamMemberToDto(member));
            }
        }
        if (report.getEvents() != null) {
            for (EightDEvent event : report.getEvents()) {
                dto.events.add(ProjectMapper.eightDEventToDto(event));
            }
        }
        if (report.getD3ContainmentInventoryRows() != null) {
            for (EightDContainmentInventoryRow row : report.getD3ContainmentInventoryRows()) {
                if (row == null || row.isTotalRow()) continue;
                dto.d3ContainmentInventoryRows.add(ProjectMapper.eightDContainmentInventoryRowToDto(row));
            }
        }
        if (report.getImages() != null) {
            for (EightDImage image : report.getImages()) {
                dto.images.add(ProjectMapper.eightDImageToDto(image));
            }
        }
        return dto;
    }

    private static ProjectDTO.EightDContainmentActionDTO eightDContainmentActionToDto(EightDContainmentAction action) {
        if (action == null) {
            return null;
        }
        ProjectDTO.EightDContainmentActionDTO dto = new ProjectDTO.EightDContainmentActionDTO();
        dto.action = ProjectMapper.nz(action.getAction());
        dto.responsiblePerson = ProjectMapper.nz(action.getResponsiblePerson());
        dto.targetDate = ProjectDTO.toIso(action.getTargetDate());
        dto.implementationDate = ProjectDTO.toIso(action.getImplementationDate());
        dto.verificationMethod = ProjectMapper.nz(action.getVerificationMethod());
        dto.qtyContained = ProjectMapper.nz(action.getQtyContained());
        dto.qtyRejected = ProjectMapper.nz(action.getQtyRejected());
        return dto;
    }

    private static ProjectDTO.EightDCorrectiveActionDTO eightDCorrectiveActionToDto(EightDCorrectiveAction action) {
        if (action == null) {
            return null;
        }
        ProjectDTO.EightDCorrectiveActionDTO dto = new ProjectDTO.EightDCorrectiveActionDTO();
        dto.action = ProjectMapper.nz(action.getAction());
        dto.responsiblePerson = ProjectMapper.nz(action.getResponsiblePerson());
        dto.targetDate = ProjectDTO.toIso(action.getTargetDate());
        dto.implementationDate = ProjectDTO.toIso(action.getImplementationDate());
        return dto;
    }

    private static ProjectDTO.EightDEffectivenessVerificationDTO eightDEffectivenessVerificationToDto(EightDEffectivenessVerification verification) {
        if (verification == null) {
            return null;
        }
        ProjectDTO.EightDEffectivenessVerificationDTO dto = new ProjectDTO.EightDEffectivenessVerificationDTO();
        dto.method = ProjectMapper.nz(verification.getMethod());
        dto.result = ProjectMapper.nz(verification.getResult());
        dto.date = ProjectDTO.toIso(verification.getDate());
        return dto;
    }

    private static ProjectDTO.EightDPreventiveActionDTO eightDPreventiveActionToDto(EightDPreventiveAction action) {
        if (action == null) {
            return null;
        }
        ProjectDTO.EightDPreventiveActionDTO dto = new ProjectDTO.EightDPreventiveActionDTO();
        dto.product = ProjectMapper.nz(action.getProduct());
        dto.lines = ProjectMapper.nz(action.getLines());
        dto.responsiblePerson = ProjectMapper.nz(action.getResponsiblePerson());
        dto.targetDate = ProjectDTO.toIso(action.getTargetDate());
        dto.implementationDate = ProjectDTO.toIso(action.getImplementationDate());
        dto.verificationMethod = ProjectMapper.nz(action.getVerificationMethod());
        dto.verificationResult = ProjectMapper.nz(action.getVerificationResult());
        dto.verificationDate = ProjectDTO.toIso(action.getVerificationDate());
        return dto;
    }

    private static ProjectDTO.EightDTeamMemberDTO eightDTeamMemberToDto(EightDTeamMember member) {
        if (member == null) {
            return null;
        }
        ProjectDTO.EightDTeamMemberDTO dto = new ProjectDTO.EightDTeamMemberDTO();
        dto.name = ProjectMapper.nz(member.getName());
        dto.roleFunction = ProjectMapper.nz(member.getRoleFunction());
        dto.department = ProjectMapper.nz(member.getDepartment());
        dto.company = ProjectMapper.nz(member.getCompany());
        dto.responsibility = ProjectMapper.nz(member.getResponsibility());
        dto.email = ProjectMapper.nz(member.getEmail());
        return dto;
    }

    private static ProjectDTO.EightDEventDTO eightDEventToDto(EightDEvent event) {
        if (event == null) {
            return null;
        }
        ProjectDTO.EightDEventDTO dto = new ProjectDTO.EightDEventDTO();
        dto.date = ProjectDTO.toIso(event.getDate());
        dto.description = ProjectMapper.nz(event.getDescription());
        dto.who = ProjectMapper.nz(event.getWho());
        dto.where = ProjectMapper.nz(event.getWhere());
        return dto;
    }

    private static ProjectDTO.EightDContainmentInventoryRowDTO eightDContainmentInventoryRowToDto(EightDContainmentInventoryRow row) {
        if (row == null) {
            return null;
        }
        ProjectDTO.EightDContainmentInventoryRowDTO dto = new ProjectDTO.EightDContainmentInventoryRowDTO();
        dto.location = ProjectMapper.nz(row.getLocation());
        dto.potentialQty = Math.max(0, row.getPotentialQty());
        dto.qtyFound = Math.max(0, row.getQtyFound());
        dto.suspectQty = Math.max(0, row.getSuspectQty());
        dto.lotChecked = ProjectMapper.nz(row.getLotChecked());
        dto.responsible = ProjectMapper.nz(row.getResponsible());
        return dto;
    }

    private static ProjectDTO.EightDImageDTO eightDImageToDto(EightDImage image) {
        if (image == null) {
            return null;
        }
        ProjectDTO.EightDImageDTO dto = new ProjectDTO.EightDImageDTO();
        dto.path = ProjectMapper.nz(image.getPath());
        return dto;
    }

    public static Project fromDto(ProjectDTO dto) {
        Project p = new Project();
        if (!ProjectMapper.isBlank(dto.id)) {
            p.setId(dto.id);
        }
        p.setName(ProjectMapper.nz(dto.name));
        p.setDescription(ProjectMapper.nz(dto.description));
        p.setProjectLeader(ProjectMapper.nz(dto.projectLeader));
        p.setProjectTeam(ProjectMapper.nz(dto.projectTeam));
        p.setStartDate(ProjectDTO.parseDate(dto.startDate));
        p.setPlant(ProjectMapper.nz(dto.plant));
        p.setPlantLocation(ProjectMapper.nz(dto.plantLocation));
        if (!ProjectMapper.isBlank(dto.status)) {
            try {
                p.setStatus(ProjectStatus.valueOf(dto.status));
            }
            catch (IllegalArgumentException ex) {
                p.setStatus(ProjectStatus.OPEN);
            }
        }
        p.clearProductTrees();
        if (dto.productTrees != null) {
            for (ProjectDTO.ItemDTO it : dto.productTrees) {
                p.addProductTree(ProjectMapper.itemFromDto(it));
            }
        }
        p.clearProcessTrees();
        if (dto.processTrees != null) {
            for (ProjectDTO.ProcessItemDTO pi : dto.processTrees) {
                p.addProcessTree(ProjectMapper.processItemFromDto(pi));
            }
        }
        p.clearDfmeas();
        if (dto.dfmeas != null) {
            for (ProjectDTO.DfmeaDTO d : dto.dfmeas) {
                p.addDfmea(ProjectMapper.dfmeaFromDto(d));
            }
        }
        p.clearPfmeas();
        if (dto.pfmeas != null) {
            for (ProjectDTO.PfmeaDTO f : dto.pfmeas) {
                p.addPfmea(ProjectMapper.pfmeaFromDto(f));
            }
        }
        p.clearControlPlan();
        if (dto.controlPlans != null) {
            for (ProjectDTO.ControlPlanDTO c : dto.controlPlans) {
                p.addControlPlan(ProjectMapper.controlPlanFromDto(c));
            }
        }
        p.clearEightDReports();
        if (dto.eightDReports != null) {
            for (ProjectDTO.EightDDTO report : dto.eightDReports) {
                p.addEightDReport(ProjectMapper.eightDFromDto(report));
            }
        }
        return p;
    }

    private static Item itemFromDto(ProjectDTO.ItemDTO dto) {
        if (dto == null) {
            return null;
        }
        Item it = new Item();
        it.setId(ProjectMapper.nz(dto.id));
        it.setPartNumber(ProjectMapper.nz(dto.partNumber));
        it.setDescription(ProjectMapper.nz(dto.description));
        it.setFunction(ProjectMapper.nz(dto.function));
        if (!ProjectMapper.isBlank(dto.type)) {
            it.setType(ItemType.valueOf(dto.type));
        }
        it.clearChildren();
        if (dto.children != null) {
            for (ProjectDTO.ItemDTO itemDTO : dto.children) {
                it.addChild(ProjectMapper.itemFromDto(itemDTO));
            }
        }
        it.clearCharacteristics();
        if (dto.characteristics != null) {
            for (ProjectDTO.CharacteristicDTO characteristicDTO : dto.characteristics) {
                it.addCharacteristic(ProjectMapper.characteristicFromDto(characteristicDTO));
            }
        }
        it.clearRequirements();
        if (dto.requirements != null) {
            for (ProjectDTO.ProductRequirementDTO productRequirementDTO : dto.requirements) {
                it.addRequirement(ProjectMapper.productRequirementFromDto(productRequirementDTO));
            }
        }
        return it;
    }

    private static ProjectDTO.ProductRequirementDTO productRequirementToDto(ProductRequirement requirement) {
        if (requirement == null) {
            return null;
        }
        ProjectDTO.ProductRequirementDTO dto = new ProjectDTO.ProductRequirementDTO();
        dto.id = ProjectMapper.nz(requirement.getId());
        dto.description = ProjectMapper.nz(requirement.getDescription());
        dto.specification = ProjectMapper.nz(requirement.getSpecification());
        dto.tolerance = ProjectMapper.nz(requirement.getTolerance());
        dto.customerImportance = requirement.getCustomerImportance();
        dto.percent = requirement.getPercent();
        return dto;
    }

    private static ProductRequirement productRequirementFromDto(ProjectDTO.ProductRequirementDTO dto) {
        if (dto == null) {
            return null;
        }
        ProductRequirement req = new ProductRequirement();
        req.setId(ProjectMapper.nz(dto.id));
        req.setDescription(ProjectMapper.nz(dto.description));
        req.setSpecification(ProjectMapper.nz(dto.specification));
        req.setTolerance(ProjectMapper.nz(dto.tolerance));
        if (dto.customerImportance != null) {
            req.setCustomerImportance(dto.customerImportance);
        }
        if (dto.percent != null) {
            req.setPercent(dto.percent);
        }
        return req;
    }

    private static Characteristic characteristicFromDto(ProjectDTO.CharacteristicDTO dto) {
        if (dto == null) {
            return null;
        }
        Characteristic c = new Characteristic();
        c.setId(ProjectMapper.nz(dto.id));
        c.setDescription(ProjectMapper.nz(dto.description));
        if (!ProjectMapper.isBlank(dto.targetValueText)) {
            c.setTargetValueText(dto.targetValueText);
        } else if (dto.targetValue != null) {
            c.setTargetValue(dto.targetValue);
        }
        if (!ProjectMapper.isBlank(dto.upperLimitText)) {
            c.setUpperLimitText(dto.upperLimitText);
        } else if (dto.upperLimit != null) {
            c.setUpperLimit(dto.upperLimit);
        }
        if (!ProjectMapper.isBlank(dto.lowerLimitText)) {
            c.setLowerLimitText(dto.lowerLimitText);
        } else if (dto.lowerLimit != null) {
            c.setLowerLimit(dto.lowerLimit);
        }
        if (!ProjectMapper.isBlank(dto.cpkText)) {
            c.setCpkText(dto.cpkText);
        } else if (dto.cpk != null) {
            c.setCpk(dto.cpk);
        }
        c.setAttribute(Boolean.TRUE.equals(dto.attribute));
        c.setCriticalToSafety(Boolean.TRUE.equals(dto.criticalToSafety));
        c.setCriticalToQuality(Boolean.TRUE.equals(dto.criticalToQuality));
        c.setCriticalToProcess(Boolean.TRUE.equals(dto.criticalToProcess));
        return c;
    }

    private static ProcessItem processItemFromDto(ProjectDTO.ProcessItemDTO dto) {
        if (dto == null) {
            return null;
        }
        ProcessItem pi = new ProcessItem();
        pi.setId(ProjectMapper.nz(dto.id));
        pi.setDescription(ProjectMapper.nz(dto.description));
        pi.setFunction(ProjectMapper.nz(dto.function));
        if (dto.time != null) {
            pi.setTime(dto.time);
        }
        if (dto.distance != null) {
            pi.setDistance(dto.distance);
        }
        if (!ProjectMapper.isBlank(dto.category)) {
            pi.setCategory(ProcessCategory.valueOf(dto.category));
        }
        if (!ProjectMapper.isBlank(dto.valueCategory)) {
            pi.setValueCategory(ValueCategory.valueOf(dto.valueCategory));
        }
        if (!ProjectMapper.isBlank(dto.type)) {
            pi.setType(ProcessType.valueOf(dto.type));
        }
        if (!ProjectMapper.isBlank(dto.ishikawa)) {
            pi.setIshikawa(Ishikawa.valueOf(dto.ishikawa));
        }
        pi.clearChildren();
        if (dto.children != null) {
            for (ProjectDTO.ProcessItemDTO c : dto.children) {
                pi.addChild(ProjectMapper.processItemFromDto(c));
            }
        }
        pi.clearParameter();
        if (dto.parameters != null) {
            for (ProjectDTO.ParameterDTO pr : dto.parameters) {
                pi.addParameter(ProjectMapper.parameterFromDto(pr));
            }
        }
        return pi;
    }

    private static Parameter parameterFromDto(ProjectDTO.ParameterDTO dto) {
        if (dto == null) {
            return null;
        }
        Parameter p = new Parameter();
        p.setId(ProjectMapper.nz(dto.id));
        p.setDescription(ProjectMapper.nz(dto.description));
        if (!ProjectMapper.isBlank(dto.targetValueText)) {
            p.setTargetValueText(dto.targetValueText);
        } else if (dto.targetValue != null) {
            p.setTargetValue(dto.targetValue);
        }
        if (!ProjectMapper.isBlank(dto.upperLimitText)) {
            p.setUpperLimitText(dto.upperLimitText);
        } else if (dto.upperLimit != null) {
            p.setUpperLimit(dto.upperLimit);
        }
        if (!ProjectMapper.isBlank(dto.lowerLimitText)) {
            p.setLowerLimitText(dto.lowerLimitText);
        } else if (dto.lowerLimit != null) {
            p.setLowerLimit(dto.lowerLimit);
        }
        p.setAttribute(Boolean.TRUE.equals(dto.attribute));
        p.setCriticalToSafety(Boolean.TRUE.equals(dto.criticalToSafety));
        p.setCriticalToQuality(Boolean.TRUE.equals(dto.criticalToQuality));
        p.setCriticalToProcess(Boolean.TRUE.equals(dto.criticalToProcess));
        return p;
    }

    private static Dfmea dfmeaFromDto(ProjectDTO.DfmeaDTO dto) {
        if (dto == null) {
            return null;
        }
        Dfmea d = new Dfmea();
        d.setCompanyName(ProjectMapper.nz(dto.companyName));
        d.setEngineeringLocation(ProjectMapper.nz(dto.engineeringLocation));
        d.setProductName(ProjectMapper.nz(dto.productName));
        d.setModelYearPlatform(ProjectMapper.nz(dto.modelYearPlatform));
        d.setDfmeaSubject(ProjectMapper.nz(dto.dfmeaSubject));
        d.setDfmeaStartDate(ProjectDTO.parseDate(dto.dfmeaStartDate));
        d.setDfmeaLastRevisionDate(ProjectDTO.parseDate(dto.dfmeaLastRevisionDate));
        d.setCrossFunctionalTeam(ProjectMapper.nz(dto.crossFunctionalTeam));
        d.setDfmeaIdNumber(ProjectMapper.nz(dto.dfmeaIdNumber));
        d.setDfmeaRevision(ProjectMapper.nz(dto.dfmeaRevision));
        d.setDesignResponsibility(ProjectMapper.nz(dto.designResponsibility));
        if (!ProjectMapper.isBlank(dto.confidentialityLevel)) {
            try {
                d.setConfidentialityLevel(ConfidentialityLevel.valueOf(dto.confidentialityLevel));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        d.getRevisionHistory().clear();
        if (dto.revisions != null) {
            for (ProjectDTO.FmeaRevisionDTO fmeaRevisionDTO : dto.revisions) {
                RevisionEntry e = new RevisionEntry();
                e.setRevisionNumber(ProjectMapper.nz(fmeaRevisionDTO.revisionNumber));
                e.setRevisionDate(ProjectDTO.parseDate(fmeaRevisionDTO.revisionDate));
                e.setAuthorName(ProjectMapper.nz(fmeaRevisionDTO.author));
                e.setDescriptionOfChanges(ProjectMapper.nz(fmeaRevisionDTO.descriptionOfChanges));
                e.setApprovalStatus(ProjectMapper.safeEnum(fmeaRevisionDTO.approvalStatus, ApprovalStatus.class));
                d.getRevisionHistory().add((Object)e);
            }
        }
        d.getFailureChains().clear();
        if (dto.failureChains != null) {
            for (ProjectDTO.DfmeaRowDTO dfmeaRowDTO : dto.failureChains) {
                d.getFailureChains().add((Object)ProjectMapper.dfmeaRowFromDto(dfmeaRowDTO));
            }
        }
        return d;
    }

    private static DfmeaRow dfmeaRowFromDto(ProjectDTO.DfmeaRowDTO dto) {
        if (dto == null) {
            return null;
        }
        DfmeaRow r = new DfmeaRow();
        r.setIssueNumber(dto.issueNumber);
        r.setChangeAuthorization(ProjectMapper.nz(dto.changeAuthorization));
        if (dto.nextHigherLevel != null) {
            r.setNextHigherLevel(ProjectMapper.itemFromDto(dto.nextHigherLevel));
        }
        if (dto.focusElement != null) {
            r.setFocusElement(ProjectMapper.itemFromDto(dto.focusElement));
        }
        r.setNextHigherLevelText(ProjectMapper.nz(dto.nextHigherLevelText));
        r.setFocusElementText(ProjectMapper.nz(dto.focusElementText));
        r.setNextLowerLevelOrCharacteristicText(ProjectMapper.nz(dto.nextLowerLevelOrCharacteristicText));
        if (dto.nextLowerLevelOrCharacteristic != null) {
            if (dto.nextLowerLevelOrCharacteristic.item != null) {
                r.setNextLowerLevelOrCharacteristic(ProjectMapper.itemFromDto(dto.nextLowerLevelOrCharacteristic.item));
            } else if (dto.nextLowerLevelOrCharacteristic.characteristic != null) {
                r.setNextLowerLevelOrCharacteristic(ProjectMapper.characteristicFromDto(dto.nextLowerLevelOrCharacteristic.characteristic));
            }
        }
        r.setNextHigherLevelFunction(ProjectMapper.nz(dto.nextHigherLevelFunction));
        r.setFocusElementFunctionRequirement(ProjectMapper.nz(dto.focusElementFunctionRequirement));
        r.setNextLowerLevelFunctionRequirementOrCharacteristic(ProjectMapper.nz(dto.nextLowerLevelFunctionRequirementOrCharacteristic));
        r.setFailureEffect(ProjectMapper.nz(dto.failureEffect));
        r.setSeverity(ProjectMapper.safeEnum(dto.severity, DfmeaRow.Severity.class));
        r.setFailureMode(ProjectMapper.nz(dto.failureMode));
        r.setFailureCause(ProjectMapper.nz(dto.failureCause));
        r.setPreventionControl(ProjectMapper.nz(dto.preventionControl));
        r.setOccurrence(ProjectMapper.safeEnum(dto.occurrence, DfmeaRow.Occurrence.class));
        r.setDetectionControl(ProjectMapper.nz(dto.detectionControl));
        r.setDetection(ProjectMapper.safeEnum(dto.detection, DfmeaRow.Detection.class));
        r.setActionPriority(ProjectMapper.safeEnum(dto.actionPriority, DfmeaRow.ActionPriority.class));
        r.setRemarks(ProjectMapper.nz(dto.remarks));
        r.setFilterCode(ProjectMapper.nz(dto.filterCode));
        r.setPreventiveAction(ProjectMapper.nz(dto.preventiveAction));
        r.setDetectionAction(ProjectMapper.nz(dto.detectionAction));
        r.setResponsiblePerson(ProjectMapper.nz(dto.responsiblePerson));
        r.setTargetCompletionDate(ProjectDTO.parseDate(dto.targetCompletionDate));
        r.setStatus(ProjectMapper.safeEnum(dto.status, DfmeaRow.DfmeaStatus.class));
        r.setActionTakenEvidence(ProjectMapper.nz(dto.actionTakenEvidence));
        r.setCompletionDate(ProjectDTO.parseDate(dto.completionDate));
        r.setCurrentSeverity(ProjectMapper.safeEnum(dto.currentSeverity, DfmeaRow.Severity.class));
        r.setCurrentOccurrence(ProjectMapper.safeEnum(dto.currentOccurrence, DfmeaRow.Occurrence.class));
        r.setCurrentDetection(ProjectMapper.safeEnum(dto.currentDetection, DfmeaRow.Detection.class));
        r.setCurrentActionPriority(ProjectMapper.safeEnum(dto.currentActionPriority, DfmeaRow.ActionPriority.class));
        return r;
    }

    private static Pfmea pfmeaFromDto(ProjectDTO.PfmeaDTO dto) {
        if (dto == null) {
            return null;
        }
        Pfmea d = new Pfmea();
        d.setCompanyName(ProjectMapper.nz(dto.companyName));
        d.setPlantLocation(ProjectMapper.nz(dto.plantLocation));
        d.setCustomerName(ProjectMapper.nz(dto.customerName));
        d.setModelYearPlatform(ProjectMapper.nz(dto.modelYearPlatform));
        d.setPfmeaSubject(ProjectMapper.nz(dto.pfmeaSubject));
        d.setPfmeaStartDate(ProjectDTO.parseDate(dto.pfmeaStartDate));
        d.setPfmeaLastRevisionDate(ProjectDTO.parseDate(dto.pfmeaLastRevisionDate));
        d.setCrossFunctionalTeam(ProjectMapper.nz(dto.crossFunctionalTeam));
        d.setPfmeaIdNumber(ProjectMapper.nz(dto.pfmeaIdNumber));
        d.setPfmeaRevision(ProjectMapper.nz(dto.pfmeaRevision));
        d.setProcessResponsibility(ProjectMapper.nz(dto.processResponsibility));
        if (!ProjectMapper.isBlank(dto.confidentialityLevel)) {
            try {
                d.setConfidentialityLevel(ConfidentialityLevel.valueOf(dto.confidentialityLevel));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        d.getRevisionHistory().clear();
        if (dto.revisions != null) {
            for (ProjectDTO.FmeaRevisionDTO fmeaRevisionDTO : dto.revisions) {
                RevisionEntry e = new RevisionEntry();
                e.setRevisionNumber(ProjectMapper.nz(fmeaRevisionDTO.revisionNumber));
                e.setRevisionDate(ProjectDTO.parseDate(fmeaRevisionDTO.revisionDate));
                e.setAuthorName(ProjectMapper.nz(fmeaRevisionDTO.author));
                e.setDescriptionOfChanges(ProjectMapper.nz(fmeaRevisionDTO.descriptionOfChanges));
                e.setApprovalStatus(ProjectMapper.safeEnum(fmeaRevisionDTO.approvalStatus, ApprovalStatus.class));
                d.getRevisionHistory().add((Object)e);
            }
        }
        d.getFailureChains().clear();
        if (dto.failureChains != null) {
            for (ProjectDTO.PfmeaRowDTO pfmeaRowDTO : dto.failureChains) {
                d.getFailureChains().add((Object)ProjectMapper.pfmeaRowFromDto(pfmeaRowDTO));
            }
        }
        return d;
    }

    private static PfmeaRow pfmeaRowFromDto(ProjectDTO.PfmeaRowDTO dto) {
        if (dto == null) {
            return null;
        }
        PfmeaRow r = new PfmeaRow();
        r.setIssueNumber(dto.issueNumber);
        r.setChangeAuthorization(ProjectMapper.nz(dto.changeAuthorization));
        if (dto.nextHigherLevel != null) {
            r.setNextHigherLevel(ProjectMapper.processItemFromDto(dto.nextHigherLevel));
        }
        if (dto.focusElement != null) {
            r.setFocusElement(ProjectMapper.processItemFromDto(dto.focusElement));
        }
        r.setNextHigherLevelText(ProjectMapper.nz(dto.nextHigherLevelText));
        r.setFocusElementText(ProjectMapper.nz(dto.focusElementText));
        r.setNextLowerLevelOrParameterText(ProjectMapper.nz(dto.nextLowerLevelOrParameterText));
        if (dto.nextLowerLevelOrParameter != null) {
            if (dto.nextLowerLevelOrParameter.processItem != null) {
                r.setNextLowerLevelOrParameter(ProjectMapper.processItemFromDto(dto.nextLowerLevelOrParameter.processItem));
            } else if (dto.nextLowerLevelOrParameter.parameter != null) {
                r.setNextLowerLevelOrParameter(ProjectMapper.parameterFromDto(dto.nextLowerLevelOrParameter.parameter));
            }
        }
        r.setNextHigherLevelFunction(ProjectMapper.nz(dto.nextHigherLevelFunction));
        r.setFocusElementFunctionRequirement(ProjectMapper.nz(dto.focusElementFunctionRequirement));
        r.setNextLowerLevelFunctionRequirementOrParameter(ProjectMapper.nz(dto.nextLowerLevelFunctionRequirementOrParameter));
        r.setFailureEffect(ProjectMapper.nz(dto.failureEffect));
        r.setSeverity(ProjectMapper.safeEnum(dto.severity, PfmeaRow.Severity.class));
        r.setFailureMode(ProjectMapper.nz(dto.failureMode));
        r.setFailureCause(ProjectMapper.nz(dto.failureCause));
        r.setPreventionControl(ProjectMapper.nz(dto.preventionControl));
        r.setOccurrence(ProjectMapper.safeEnum(dto.occurrence, PfmeaRow.Occurrence.class));
        r.setDetectionControl(ProjectMapper.nz(dto.detectionControl));
        r.setDetection(ProjectMapper.safeEnum(dto.detection, PfmeaRow.Detection.class));
        r.setActionPriority(ProjectMapper.safeEnum(dto.actionPriority, PfmeaRow.ActionPriority.class));
        r.setRemarks(ProjectMapper.nz(dto.remarks));
        r.setFilterCode(ProjectMapper.nz(dto.filterCode));
        r.setPreventiveAction(ProjectMapper.nz(dto.preventiveAction));
        r.setDetectionAction(ProjectMapper.nz(dto.detectionAction));
        r.setResponsiblePerson(ProjectMapper.nz(dto.responsiblePerson));
        r.setTargetCompletionDate(ProjectDTO.parseDate(dto.targetCompletionDate));
        r.setStatus(ProjectMapper.safeEnum(dto.status, PfmeaRow.PfmeaStatus.class));
        r.setActionTakenEvidence(ProjectMapper.nz(dto.actionTakenEvidence));
        r.setCompletionDate(ProjectDTO.parseDate(dto.completionDate));
        r.setCurrentSeverity(ProjectMapper.safeEnum(dto.currentSeverity, PfmeaRow.Severity.class));
        r.setCurrentOccurrence(ProjectMapper.safeEnum(dto.currentOccurrence, PfmeaRow.Occurrence.class));
        r.setCurrentDetection(ProjectMapper.safeEnum(dto.currentDetection, PfmeaRow.Detection.class));
        r.setCurrentActionPriority(ProjectMapper.safeEnum(dto.currentActionPriority, PfmeaRow.ActionPriority.class));
        return r;
    }

    private static ControlPlan controlPlanFromDto(ProjectDTO.ControlPlanDTO dto) {
        if (dto == null) {
            return null;
        }
        ControlPlan c = new ControlPlan();
        c.setCpNumber(ProjectMapper.nz(dto.cpNumber));
        c.setCpKeyContact(ProjectMapper.nz(dto.cpKeyContact));
        c.setCpCustomerEngApproval(ProjectMapper.nz(dto.cpCustomerEngApproval));
        c.setCpCustomerQualApproval(ProjectMapper.nz(dto.cpCustomerQualApproval));
        c.setCpCustomerOtherApproval(ProjectMapper.nz(dto.cpCustomerOtherApproval));
        c.setCpSupplierPlantApproval(ProjectMapper.nz(dto.cpSupplierPlantApproval));
        c.setCpSupplierOtherApproval(ProjectMapper.nz(dto.cpSupplierOtherApproval));
        c.setCpStartDate(ProjectDTO.parseDate(dto.cpStartDate));
        c.setCpRevisionDate(ProjectDTO.parseDate(dto.cpRevisionDate));
        c.setCpRevision(ProjectMapper.nz(dto.cpRevision));
        c.setCpLevel(ProjectMapper.safeEnum(dto.cpLevel, ControlPlanLevel.class));
        c.setCpPartNumber(ProjectMapper.nz(dto.cpPartNumber));
        c.setCpPartName(ProjectMapper.nz(dto.cpPartName));
        c.setCrossFunctionalTeam(ProjectMapper.nz(dto.crossFunctionalTeam));
        c.setSupplierPlant(ProjectMapper.nz(dto.supplierPlant));
        c.setSupplierCode(ProjectMapper.nz(dto.supplierCode));
        c.getRevisionHistory().clear();
        if (dto.revisions != null) {
            for (ProjectDTO.FmeaRevisionDTO fmeaRevisionDTO : dto.revisions) {
                RevisionEntry e = new RevisionEntry();
                e.setRevisionNumber(ProjectMapper.nz(fmeaRevisionDTO.revisionNumber));
                e.setRevisionDate(ProjectDTO.parseDate(fmeaRevisionDTO.revisionDate));
                e.setAuthorName(ProjectMapper.nz(fmeaRevisionDTO.author));
                e.setDescriptionOfChanges(ProjectMapper.nz(fmeaRevisionDTO.descriptionOfChanges));
                e.setApprovalStatus(ProjectMapper.safeEnum(fmeaRevisionDTO.approvalStatus, ApprovalStatus.class));
                c.getRevisionHistory().add((Object)e);
            }
        }
        c.getControlChains().clear();
        if (dto.controlChains != null) {
            for (ProjectDTO.ControlPlanRowDTO controlPlanRowDTO : dto.controlChains) {
                c.addControlChain(ProjectMapper.controlPlanRowFromDto(controlPlanRowDTO));
            }
        }
        return c;
    }

    private static ControlPlanRow controlPlanRowFromDto(ProjectDTO.ControlPlanRowDTO dto) {
        if (dto == null) {
            return null;
        }
        ControlPlanRow r = new ControlPlanRow(UUID.randomUUID());
        if (!ProjectMapper.isBlank(dto.id)) {
            try {
                r.setId(UUID.fromString(dto.id));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        r.setPartOrProcessNumber(ProjectMapper.nz(dto.partOrProcessNumber));
        r.setProcessNameOrOperationDescription(ProjectMapper.nz(dto.processNameOrOperationDescription));
        r.setMachineDeviceJigToolForMfg(ProjectMapper.nz(dto.machineDeviceJigToolForMfg));
        r.setNumber(ProjectMapper.nz(dto.Number));
        r.setCharacteristicOrParameter(ProjectMapper.nz(dto.CharacteristicOrParameter));
        r.setProductCharacteristic(ProjectMapper.nz(dto.productCharacteristic));
        r.setProcessCharacteristic(ProjectMapper.nz(dto.processCharacteristic));
        r.setIsCriticalToQuality(Boolean.TRUE.equals(dto.isCriticalToQuality));
        r.setIsCriticalToSafety(Boolean.TRUE.equals(dto.isCriticalToSafety));
        r.setIsCriticalToProcess(Boolean.TRUE.equals(dto.isCriticalToProcess));
        r.setAttribute(Boolean.TRUE.equals(dto.attribute));
        r.setTargetValue(ProjectMapper.nz(dto.targetValue));
        r.setUpperLimit(ProjectMapper.nz(dto.upperLimit));
        r.setLowerLimit(ProjectMapper.nz(dto.lowerLimit));
        r.setEvaluationMeasurementTechnique(ProjectMapper.nz(dto.evaluationMeasurementTechnique));
        r.setSampleSize(ProjectMapper.nz(dto.sampleSize));
        r.setSampleFrequency(ProjectMapper.nz(dto.sampleFrequency));
        r.setControlMethod(ProjectMapper.nz(dto.controlMethod));
        r.setReactionPlan(ProjectMapper.nz(dto.reactionPlan));
        return r;
    }

    private static EightD eightDFromDto(ProjectDTO.EightDDTO dto) {
        Object mapped;
        if (dto == null) {
            return null;
        }
        EightD report = new EightD();
        report.setDateOpened(ProjectDTO.parseDate(dto.dateOpened));
        report.setDateRevised(ProjectDTO.parseDate(dto.dateRevised));
        report.setClosedDate(ProjectDTO.parseDate(dto.closedDate));
        report.setContainmentDueDate(ProjectDTO.parseDate(dto.containmentDueDate));
        report.setStatus(ProjectMapper.nz(dto.status));
        report.setCustomer(ProjectMapper.nz(dto.customer));
        report.setCustomerClaimNumber(ProjectMapper.nz(dto.customerClaimNumber));
        report.setInternalClaimNumber(ProjectMapper.nz(dto.internalClaimNumber));
        report.setInternalContact(ProjectMapper.nz(dto.internalContact));
        report.setCustomerContact(ProjectMapper.nz(dto.customerContact));
        report.setPartNumber(ProjectMapper.nz(dto.partNumber));
        report.setPartDescription(ProjectMapper.nz(dto.partDescription));
        report.setQuantity(ProjectMapper.nz(dto.quantity));
        report.setNonConformanceNotification(ProjectMapper.nz(dto.nonConformanceNotification));
        report.setProblemDescription(ProjectMapper.nz(dto.problemDescription));
        report.setD2IsWhat(ProjectMapper.nz(dto.d2IsWhat));
        report.setD2IsNotWhat(ProjectMapper.nz(dto.d2IsNotWhat));
        report.setD2IsWhere(ProjectMapper.nz(dto.d2IsWhere));
        report.setD2IsNotWhere(ProjectMapper.nz(dto.d2IsNotWhere));
        report.setD2IsWhen(ProjectMapper.nz(dto.d2IsWhen));
        report.setD2IsNotWhen(ProjectMapper.nz(dto.d2IsNotWhen));
        report.setD2IsHowMany(ProjectMapper.nz(dto.d2IsHowMany));
        report.setD2IsNotHowMany(ProjectMapper.nz(dto.d2IsNotHowMany));
        report.setD2WhatContrast(Boolean.TRUE.equals(dto.d2WhatContrast));
        report.setD2WhereContrast(Boolean.TRUE.equals(dto.d2WhereContrast));
        report.setD2WhenContrast(Boolean.TRUE.equals(dto.d2WhenContrast));
        report.setD2HowManyContrast(Boolean.TRUE.equals(dto.d2HowManyContrast));
        report.setD2DiffContrast1(ProjectMapper.nz(dto.d2DiffContrast1));
        report.setD2DiffChange1(ProjectMapper.nz(dto.d2DiffChange1));
        report.setD2DiffContrast2(ProjectMapper.nz(dto.d2DiffContrast2));
        report.setD2DiffChange2(ProjectMapper.nz(dto.d2DiffChange2));
        report.setD2DiffContrast3(ProjectMapper.nz(dto.d2DiffContrast3));
        report.setD2DiffChange3(ProjectMapper.nz(dto.d2DiffChange3));
        report.setD2DiffContrast4(ProjectMapper.nz(dto.d2DiffContrast4));
        report.setD2DiffChange4(ProjectMapper.nz(dto.d2DiffChange4));
        report.setD3ContainmentChampion(ProjectMapper.nz(dto.d3ContainmentChampion));
        report.setD3ContainmentIssueNumber(ProjectMapper.nz(dto.d3ContainmentIssueNumber));
        report.setD3ContainmentDate(ProjectDTO.parseDate(dto.d3ContainmentDate));
        report.setD3ContainmentProductName(ProjectMapper.nz(dto.d3ContainmentProductName));
        report.setD3ContainmentPartNumber(ProjectMapper.nz(dto.d3ContainmentPartNumber));
        report.setD3ContainmentProductNonconformance(ProjectMapper.nz(dto.d3ContainmentProductNonconformance));
        report.setD3ContainmentInstructions(ProjectMapper.nz(dto.d3ContainmentInstructions));
        report.setD3ContainmentSegregateTo(ProjectMapper.nz(dto.d3ContainmentSegregateTo));
        report.setD3ContainmentIdentificationConforming(ProjectMapper.nz(dto.d3ContainmentIdentificationConforming));
        report.setD3ContainmentIdentificationNonConforming(ProjectMapper.nz(dto.d3ContainmentIdentificationNonConforming));
        report.setD3ContainmentQualityManager(ProjectMapper.nz(dto.d3ContainmentQualityManager));
        report.setD3ContainmentQualityManagerDate(ProjectDTO.parseDate(dto.d3ContainmentQualityManagerDate));
        report.setD8SubmittedBy(ProjectMapper.nz(dto.d8SubmittedBy));
        report.setD8SubmissionDate(ProjectDTO.parseDate(dto.d8SubmissionDate));
        report.setD8InternalQualityRepresentative(ProjectMapper.nz(dto.d8InternalQualityRepresentative));
        report.setD8InternalQualityApprovalDate(ProjectDTO.parseDate(dto.d8InternalQualityApprovalDate));
        report.setD8InternalRepresentative1(ProjectMapper.nz(dto.d8InternalRepresentative1));
        report.setD8InternalRepresentative1ApprovalDate(ProjectDTO.parseDate(dto.d8InternalRepresentative1ApprovalDate));
        report.setD8InternalRepresentative2(ProjectMapper.nz(dto.d8InternalRepresentative2));
        report.setD8InternalRepresentative2ApprovalDate(ProjectDTO.parseDate(dto.d8InternalRepresentative2ApprovalDate));
        ProjectMapper.copyStringList(dto.possibleCausesMethod, report.getPossibleCausesMethod());
        ProjectMapper.copyStringList(dto.possibleCausesMachine, report.getPossibleCausesMachine());
        ProjectMapper.copyStringList(dto.possibleCausesMaterial, report.getPossibleCausesMaterial());
        ProjectMapper.copyStringList(dto.possibleCausesManpower, report.getPossibleCausesManpower());
        report.setIshikawaFailureDescription(ProjectMapper.nz(dto.ishikawaFailureDescription));
        ProjectMapper.copyStringList(dto.ishikawaCausesMethod, report.getIshikawaCausesMethod());
        ProjectMapper.copyStringList(dto.ishikawaCausesMachine, report.getIshikawaCausesMachine());
        ProjectMapper.copyStringList(dto.ishikawaCausesMeasurements, report.getIshikawaCausesMeasurements());
        ProjectMapper.copyStringList(dto.ishikawaCausesEnvironment, report.getIshikawaCausesEnvironment());
        ProjectMapper.copyStringList(dto.ishikawaCausesMaterial, report.getIshikawaCausesMaterial());
        ProjectMapper.copyStringList(dto.ishikawaCausesManpower, report.getIshikawaCausesManpower());
        report.setFiveWhysFailureDescription(ProjectMapper.nz(dto.fiveWhysFailureDescription));
        report.setFiveWhysProposedActions(ProjectMapper.nz(dto.fiveWhysProposedActions));
        ProjectMapper.copyStringList(dto.fiveWhysQuestions, report.getFiveWhysWhy());
        ProjectMapper.copyStringList(dto.fiveWhysAnswers, report.getFiveWhysAnswers());
        report.getContainmentActions().clear();
        if (dto.containmentActions != null) {
            for (ProjectDTO.EightDContainmentActionDTO eightDContainmentActionDTO : dto.containmentActions) {
                mapped = ProjectMapper.eightDContainmentActionFromDto(eightDContainmentActionDTO);
                if (mapped == null) continue;
                report.getContainmentActions().add(mapped);
            }
        }
        report.getCorrectiveActions().clear();
        if (dto.correctiveActions != null) {
            for (ProjectDTO.EightDCorrectiveActionDTO eightDCorrectiveActionDTO : dto.correctiveActions) {
                mapped = ProjectMapper.eightDCorrectiveActionFromDto(eightDCorrectiveActionDTO);
                if (mapped == null) continue;
                report.getCorrectiveActions().add(mapped);
            }
        }
        report.getEffectivenessVerifications().clear();
        if (dto.effectivenessVerifications != null) {
            for (ProjectDTO.EightDEffectivenessVerificationDTO eightDEffectivenessVerificationDTO : dto.effectivenessVerifications) {
                mapped = ProjectMapper.eightDEffectivenessVerificationFromDto(eightDEffectivenessVerificationDTO);
                if (mapped == null) continue;
                report.getEffectivenessVerifications().add(mapped);
            }
        }
        report.getPreventiveActions().clear();
        if (dto.preventiveActions != null) {
            for (ProjectDTO.EightDPreventiveActionDTO eightDPreventiveActionDTO : dto.preventiveActions) {
                mapped = ProjectMapper.eightDPreventiveActionFromDto(eightDPreventiveActionDTO);
                if (mapped == null) continue;
                report.getPreventiveActions().add(mapped);
            }
        }
        report.setD7DesignFmeaChecked(Boolean.TRUE.equals(dto.d7DesignFmeaChecked));
        report.setD7DesignFmeaDate(ProjectDTO.parseDate(dto.d7DesignFmeaDate));
        report.setD7ProcessFmeaChecked(Boolean.TRUE.equals(dto.d7ProcessFmeaChecked));
        report.setD7ProcessFmeaDate(ProjectDTO.parseDate(dto.d7ProcessFmeaDate));
        report.setD7ControlPlansChecked(Boolean.TRUE.equals(dto.d7ControlPlansChecked));
        report.setD7ControlPlansDate(ProjectDTO.parseDate(dto.d7ControlPlansDate));
        report.setD7GageDrawingChecked(Boolean.TRUE.equals(dto.d7GageDrawingChecked));
        report.setD7GageDrawingDate(ProjectDTO.parseDate(dto.d7GageDrawingDate));
        report.setD7ProcessFlowChecked(Boolean.TRUE.equals(dto.d7ProcessFlowChecked));
        report.setD7ProcessFlowDate(ProjectDTO.parseDate(dto.d7ProcessFlowDate));
        report.setD7WorkInstructionsChecked(Boolean.TRUE.equals(dto.d7WorkInstructionsChecked));
        report.setD7WorkInstructionsDate(ProjectDTO.parseDate(dto.d7WorkInstructionsDate));
        report.setD7DrawingChecked(Boolean.TRUE.equals(dto.d7DrawingChecked));
        report.setD7DrawingDate(ProjectDTO.parseDate(dto.d7DrawingDate));
        report.setD7DesignStandardsChecked(Boolean.TRUE.equals(dto.d7DesignStandardsChecked));
        report.setD7DesignStandardsDate(ProjectDTO.parseDate(dto.d7DesignStandardsDate));
        report.setD7PackingSpecsChecked(Boolean.TRUE.equals(dto.d7PackingSpecsChecked));
        report.setD7PackingSpecsDate(ProjectDTO.parseDate(dto.d7PackingSpecsDate));
        report.setD7InternalAuditChecked(Boolean.TRUE.equals(dto.d7InternalAuditChecked));
        report.setD7InternalAuditDate(ProjectDTO.parseDate(dto.d7InternalAuditDate));
        report.setD7ToolingDrawingChecked(Boolean.TRUE.equals(dto.d7ToolingDrawingChecked));
        report.setD7ToolingDrawingDate(ProjectDTO.parseDate(dto.d7ToolingDrawingDate));
        report.setD7OperatorTrainingChecked(Boolean.TRUE.equals(dto.d7OperatorTrainingChecked));
        report.setD7OperatorTrainingDate(ProjectDTO.parseDate(dto.d7OperatorTrainingDate));
        report.getTeamMembers().clear();
        if (dto.teamMembers != null) {
            for (ProjectDTO.EightDTeamMemberDTO eightDTeamMemberDTO : dto.teamMembers) {
                mapped = ProjectMapper.eightDTeamMemberFromDto(eightDTeamMemberDTO);
                if (mapped == null) continue;
                report.getTeamMembers().add(mapped);
            }
        }
        report.getEvents().clear();
        if (dto.events != null) {
            for (ProjectDTO.EightDEventDTO eightDEventDTO : dto.events) {
                mapped = ProjectMapper.eightDEventFromDto(eightDEventDTO);
                if (mapped == null) continue;
                report.getEvents().add(mapped);
            }
        }
        report.getD3ContainmentInventoryRows().clear();
        if (dto.d3ContainmentInventoryRows != null) {
            for (ProjectDTO.EightDContainmentInventoryRowDTO eightDContainmentInventoryRowDTO : dto.d3ContainmentInventoryRows) {
                mapped = ProjectMapper.eightDContainmentInventoryRowFromDto(eightDContainmentInventoryRowDTO);
                if (mapped == null) continue;
                report.getD3ContainmentInventoryRows().add(mapped);
            }
        }
        report.getImages().clear();
        if (dto.images != null) {
            for (ProjectDTO.EightDImageDTO eightDImageDTO : dto.images) {
                mapped = ProjectMapper.eightDImageFromDto(eightDImageDTO);
                if (mapped == null) continue;
                report.getImages().add(mapped);
            }
        }
        return report;
    }

    private static EightDContainmentAction eightDContainmentActionFromDto(ProjectDTO.EightDContainmentActionDTO dto) {
        if (dto == null) {
            return null;
        }
        EightDContainmentAction action = new EightDContainmentAction();
        action.setAction(ProjectMapper.nz(dto.action));
        action.setResponsiblePerson(ProjectMapper.nz(dto.responsiblePerson));
        action.setTargetDate(ProjectDTO.parseDate(dto.targetDate));
        action.setImplementationDate(ProjectDTO.parseDate(dto.implementationDate));
        action.setVerificationMethod(ProjectMapper.nz(dto.verificationMethod));
        action.setQtyContained(ProjectMapper.nz(dto.qtyContained));
        action.setQtyRejected(ProjectMapper.nz(dto.qtyRejected));
        return action;
    }

    private static EightDCorrectiveAction eightDCorrectiveActionFromDto(ProjectDTO.EightDCorrectiveActionDTO dto) {
        if (dto == null) {
            return null;
        }
        EightDCorrectiveAction action = new EightDCorrectiveAction();
        action.setAction(ProjectMapper.nz(dto.action));
        action.setResponsiblePerson(ProjectMapper.nz(dto.responsiblePerson));
        action.setTargetDate(ProjectDTO.parseDate(dto.targetDate));
        action.setImplementationDate(ProjectDTO.parseDate(dto.implementationDate));
        return action;
    }

    private static EightDEffectivenessVerification eightDEffectivenessVerificationFromDto(ProjectDTO.EightDEffectivenessVerificationDTO dto) {
        if (dto == null) {
            return null;
        }
        EightDEffectivenessVerification verification = new EightDEffectivenessVerification();
        verification.setMethod(ProjectMapper.nz(dto.method));
        verification.setResult(ProjectMapper.nz(dto.result));
        verification.setDate(ProjectDTO.parseDate(dto.date));
        return verification;
    }

    private static EightDPreventiveAction eightDPreventiveActionFromDto(ProjectDTO.EightDPreventiveActionDTO dto) {
        if (dto == null) {
            return null;
        }
        EightDPreventiveAction action = new EightDPreventiveAction();
        action.setProduct(ProjectMapper.nz(dto.product));
        action.setLines(ProjectMapper.nz(dto.lines));
        action.setResponsiblePerson(ProjectMapper.nz(dto.responsiblePerson));
        action.setTargetDate(ProjectDTO.parseDate(dto.targetDate));
        action.setImplementationDate(ProjectDTO.parseDate(dto.implementationDate));
        action.setVerificationMethod(ProjectMapper.nz(dto.verificationMethod));
        action.setVerificationResult(ProjectMapper.nz(dto.verificationResult));
        action.setVerificationDate(ProjectDTO.parseDate(dto.verificationDate));
        return action;
    }

    private static EightDTeamMember eightDTeamMemberFromDto(ProjectDTO.EightDTeamMemberDTO dto) {
        if (dto == null) {
            return null;
        }
        EightDTeamMember member = new EightDTeamMember();
        member.setName(ProjectMapper.nz(dto.name));
        member.setRoleFunction(ProjectMapper.nz(dto.roleFunction));
        member.setDepartment(ProjectMapper.nz(dto.department));
        member.setCompany(ProjectMapper.nz(dto.company));
        member.setResponsibility(ProjectMapper.nz(dto.responsibility));
        member.setEmail(ProjectMapper.nz(dto.email));
        return member;
    }

    private static EightDEvent eightDEventFromDto(ProjectDTO.EightDEventDTO dto) {
        if (dto == null) {
            return null;
        }
        EightDEvent event = new EightDEvent();
        event.setDate(ProjectDTO.parseDate(dto.date));
        event.setDescription(ProjectMapper.nz(dto.description));
        event.setWho(ProjectMapper.nz(dto.who));
        event.setWhere(ProjectMapper.nz(dto.where));
        return event;
    }

    private static EightDContainmentInventoryRow eightDContainmentInventoryRowFromDto(ProjectDTO.EightDContainmentInventoryRowDTO dto) {
        if (dto == null || ProjectMapper.isBlank(dto.location) || "Total".equalsIgnoreCase(dto.location)) {
            return null;
        }
        EightDContainmentInventoryRow row = new EightDContainmentInventoryRow();
        row.setLocation(ProjectMapper.nz(dto.location));
        row.setPotentialQty(dto.potentialQty == null ? 0 : Math.max(0, dto.potentialQty));
        row.setQtyFound(dto.qtyFound == null ? 0 : Math.max(0, dto.qtyFound));
        row.setSuspectQty(dto.suspectQty == null ? 0 : Math.max(0, dto.suspectQty));
        row.setLotChecked(ProjectMapper.nz(dto.lotChecked));
        row.setResponsible(ProjectMapper.nz(dto.responsible));
        row.setTotalRow(false);
        return row;
    }

    private static EightDImage eightDImageFromDto(ProjectDTO.EightDImageDTO dto) {
        if (dto == null) {
            return null;
        }
        EightDImage image = new EightDImage();
        image.setPath(ProjectMapper.nz(dto.path));
        return image;
    }

    private static String nz(String s) {
        return s == null ? "" : s;
    }

    private static void copyStringList(List<String> from, List<String> to) {
        if (to == null) {
            return;
        }
        to.clear();
        if (from == null) {
            return;
        }
        for (String value : from) {
            to.add(ProjectMapper.nz(value));
        }
    }

    private static String blankToNull(String s) {
        return ProjectMapper.isBlank(s) ? null : s;
    }

    private static boolean isBlank(String s) {
        return s == null || s.isBlank();
    }

    private static Double nn(double v) {
        return v;
    }

    private static <E extends Enum<E>> E safeEnum(String name, Class<E> type) {
        if (ProjectMapper.isBlank(name)) {
            return null;
        }
        try {
            return Enum.valueOf(type, name);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

