/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.item;

import com.qualidadeeprodutividade.item.Characteristic;
import com.qualidadeeprodutividade.item.ItemType;
import com.qualidadeeprodutividade.item.ProductRequirement;
import java.util.Objects;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Item {
    private final StringProperty id = new SimpleStringProperty((Object)this, "id", UUID.randomUUID().toString());
    private final StringProperty partNumber = new SimpleStringProperty((Object)this, "partNumber", "");
    private final StringProperty description = new SimpleStringProperty((Object)this, "description", "");
    private final StringProperty function = new SimpleStringProperty((Object)this, "function", "");
    private final ObjectProperty<ItemType> type = new SimpleObjectProperty((Object)this, "type", (Object)ItemType.PART);
    private final ObservableList<Item> children = FXCollections.observableArrayList();
    private final ObservableList<Characteristic> characteristics = FXCollections.observableArrayList();
    private final ObservableList<ProductRequirement> requirements = FXCollections.observableArrayList();

    public Item() {
    }

    public Item(String description, String function, String partNumber, ItemType type) {
        this.setDescription(description);
        this.setFunction(function);
        this.setPartNumber(partNumber);
        this.setType(type == null ? ItemType.PART : type);
    }

    public StringProperty idProperty() {
        return this.id;
    }

    public String getId() {
        return (String)this.id.get();
    }

    public void setId(String v) {
        this.id.set((Object)(v == null || v.isBlank() ? UUID.randomUUID().toString() : v));
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String v) {
        this.description.set((Object)(v == null ? "" : v));
    }

    public StringProperty functionProperty() {
        return this.function;
    }

    public String getFunction() {
        return (String)this.function.get();
    }

    public void setFunction(String v) {
        this.function.set((Object)(v == null ? "" : v));
    }

    public StringProperty partNumberProperty() {
        return this.partNumber;
    }

    public String getPartNumber() {
        return (String)this.partNumber.get();
    }

    public void setPartNumber(String v) {
        this.partNumber.set((Object)(v == null ? "" : v));
    }

    public ObjectProperty<ItemType> typeProperty() {
        return this.type;
    }

    public ItemType getType() {
        return (ItemType)((Object)this.type.get());
    }

    public void setType(ItemType v) {
        this.type.set((Object)v);
    }

    public ObservableList<Item> getChildren() {
        return this.children;
    }

    public void addChild(Item child) {
        if (child != null) {
            this.children.add((Object)child);
        }
    }

    public boolean removeChild(Item child) {
        return this.children.remove((Object)child);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public ObservableList<Characteristic> getCharacteristics() {
        return this.characteristics;
    }

    public void addCharacteristic(Characteristic characteristic) {
        if (characteristic != null) {
            this.characteristics.add((Object)characteristic);
        }
    }

    public boolean removeCharacteristic(Characteristic characteristic) {
        return this.characteristics.remove((Object)characteristic);
    }

    public void clearCharacteristics() {
        this.characteristics.clear();
    }

    public ObservableList<ProductRequirement> getRequirements() {
        return this.requirements;
    }

    public void addRequirement(ProductRequirement requirement) {
        if (requirement != null) {
            this.requirements.add((Object)requirement);
        }
    }

    public boolean removeRequirement(ProductRequirement requirement) {
        return this.requirements.remove((Object)requirement);
    }

    public void clearRequirements() {
        this.requirements.clear();
    }

    public String toString() {
        String d = this.getDescription();
        return d == null || d.isBlank() ? "(item)" : d;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Item)) {
            return false;
        }
        Item other = (Item)o;
        return Objects.equals(this.getId(), other.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }
}

