/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.item;

import com.qualidadeeprodutividade.item.Characteristic;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.item.ProductRequirement;

public final class StructureCloner {
    private StructureCloner() {
    }

    public static Item cloneItem(Item original) {
        Object cloned;
        if (original == null) {
            return null;
        }
        Item copy = new Item();
        copy.setDescription(original.getDescription());
        copy.setFunction(original.getFunction());
        copy.setPartNumber(original.getPartNumber());
        copy.setType(original.getType());
        if (original.getChildren() != null) {
            for (Item child : original.getChildren()) {
                Item childClone = StructureCloner.cloneItem(child);
                if (childClone == null) continue;
                copy.addChild(childClone);
            }
        }
        if (original.getCharacteristics() != null) {
            for (Characteristic ch : original.getCharacteristics()) {
                cloned = StructureCloner.cloneCharacteristic(ch);
                if (cloned == null) continue;
                copy.addCharacteristic((Characteristic)cloned);
            }
        }
        if (original.getRequirements() != null) {
            for (ProductRequirement req : original.getRequirements()) {
                cloned = StructureCloner.cloneRequirement(req);
                if (cloned == null) continue;
                copy.addRequirement((ProductRequirement)cloned);
            }
        }
        return copy;
    }

    public static Characteristic cloneCharacteristic(Characteristic original) {
        if (original == null) {
            return null;
        }
        Characteristic copy = new Characteristic();
        copy.setDescription(original.getDescription());
        copy.setTargetValueText(original.getTargetValueText());
        copy.setLowerLimitText(original.getLowerLimitText());
        copy.setUpperLimitText(original.getUpperLimitText());
        copy.setCpkText(original.getCpkText());
        copy.setAttribute(original.isAttribute());
        copy.setCriticalToSafety(original.isCriticalToSafety());
        copy.setCriticalToQuality(original.isCriticalToQuality());
        copy.setCriticalToProcess(original.isCriticalToProcess());
        return copy;
    }

    public static ProductRequirement cloneRequirement(ProductRequirement original) {
        if (original == null) {
            return null;
        }
        ProductRequirement copy = new ProductRequirement();
        copy.setDescription(original.getDescription());
        copy.setSpecification(original.getSpecification());
        copy.setTolerance(original.getTolerance());
        copy.setCustomerImportance(original.getCustomerImportance());
        copy.setPercent(original.getPercent());
        return copy;
    }
}

