/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.pdf;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.openpdf.text.Image;

public final class PdfAssets {
    private static final String LOGO_RESOURCE = "/icons/icon.png";
    private static volatile byte[] logoBytes;

    private PdfAssets() {
    }

    public static Image loadLogo() {
        byte[] data = PdfAssets.ensureLogoBytes();
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            return Image.getInstance((byte[])data);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Image loadLogo(Path logoPath) {
        if (logoPath == null) {
            return PdfAssets.loadLogo();
        }
        byte[] data = PdfAssets.readFileBytes(logoPath);
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            return Image.getInstance((byte[])data);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] loadLogoBytes() {
        byte[] data = PdfAssets.ensureLogoBytes();
        return data == null || data.length == 0 ? null : (byte[])data.clone();
    }

    public static byte[] loadLogoBytes(Path logoPath) {
        if (logoPath == null) {
            return PdfAssets.loadLogoBytes();
        }
        byte[] data = PdfAssets.readImageAsPngBytes(logoPath);
        return data == null || data.length == 0 ? null : data;
    }

    private static byte[] ensureLogoBytes() {
        byte[] data = logoBytes;
        if (data == null) {
            logoBytes = data = PdfAssets.readLogoBytes();
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readLogoBytes() {
        try (InputStream in = PdfAssets.class.getResourceAsStream(LOGO_RESOURCE);){
            if (in == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static byte[] readFileBytes(Path path) {
        try {
            if (path == null || !Files.isRegularFile(path, new LinkOption[0])) {
                return null;
            }
            return Files.readAllBytes(path);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static byte[] readImageAsPngBytes(Path path) {
        try {
            if (path == null || !Files.isRegularFile(path, new LinkOption[0])) {
                return null;
            }
            BufferedImage image = ImageIO.read(path.toFile());
            if (image == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (!ImageIO.write((RenderedImage)image, "png", out)) {
                return null;
            }
            return out.toByteArray();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

