/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.platform;

import java.nio.file.Path;
import java.util.Locale;

public final class AppPaths {
    private static final String APP_NAME = "CoreTools";
    private static final String LINUX_APP_DIR = "coretools";

    private AppPaths() {
    }

    public static Path applicationDataDirectory() {
        String home = System.getProperty("user.home", ".");
        String osName = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        if (osName.contains("mac")) {
            return Path.of(home, "Library", "Application Support", APP_NAME);
        }
        if (osName.contains("win")) {
            String appData = System.getenv("APPDATA");
            if (appData != null && !appData.isBlank()) {
                return Path.of(appData, APP_NAME);
            }
            return Path.of(home, "AppData", "Roaming", APP_NAME);
        }
        String xdgDataHome = System.getenv("XDG_DATA_HOME");
        if (xdgDataHome != null && !xdgDataHome.isBlank()) {
            return Path.of(xdgDataHome, LINUX_APP_DIR);
        }
        return Path.of(home, ".local", "share", LINUX_APP_DIR);
    }

    public static Path demosDirectory() {
        return AppPaths.applicationDataDirectory().resolve("demos");
    }

    public static Path reportsDirectory() {
        return AppPaths.applicationDataDirectory().resolve("reports");
    }

    public static Path locksDirectory() {
        return AppPaths.applicationDataDirectory().resolve("locks");
    }

    public static Path eightDImagesDirectory() {
        return AppPaths.applicationDataDirectory().resolve("eightd-images");
    }

    public static Path legacyHiddenDirectory() {
        return Path.of(System.getProperty("user.home", "."), ".coretools");
    }
}

