/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.processItem;

import java.util.Objects;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Parameter {
    private final StringProperty id = new SimpleStringProperty((Object)this, "id", UUID.randomUUID().toString());
    private final StringProperty description = new SimpleStringProperty((Object)this, "description", "");
    private final DoubleProperty targetValue = new SimpleDoubleProperty((Object)this, "targetValue", Double.NaN);
    private final DoubleProperty upperLimit = new SimpleDoubleProperty((Object)this, "upperLimit", Double.NaN);
    private final DoubleProperty lowerLimit = new SimpleDoubleProperty((Object)this, "lowerLimit", Double.NaN);
    private final StringProperty targetValueText = new SimpleStringProperty((Object)this, "targetValueText", "");
    private final StringProperty upperLimitText = new SimpleStringProperty((Object)this, "upperLimitText", "");
    private final StringProperty lowerLimitText = new SimpleStringProperty((Object)this, "lowerLimitText", "");
    private final BooleanProperty attribute = new SimpleBooleanProperty((Object)this, "attribute", false);
    private final BooleanProperty criticalToSafety = new SimpleBooleanProperty((Object)this, "criticalToSafety", false);
    private final BooleanProperty criticalToQuality = new SimpleBooleanProperty((Object)this, "criticalToQuality", false);
    private final BooleanProperty criticalToProcess = new SimpleBooleanProperty((Object)this, "criticalToProcess", false);

    public Parameter() {
    }

    public Parameter(String description) {
        this.setDescription(description);
    }

    public Parameter(String description, double targetValue, double lowerLimit, double upperLimit, boolean attribute, boolean criticalToSafety, boolean criticalToQuality, boolean criticalToProcess) {
        this.setDescription(description);
        this.setTargetValue(targetValue);
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
        this.setAttribute(attribute);
        this.setCriticalToSafety(criticalToSafety);
        this.setCriticalToQuality(criticalToQuality);
        this.setCriticalToProcess(criticalToProcess);
    }

    public StringProperty idProperty() {
        return this.id;
    }

    public String getId() {
        return (String)this.id.get();
    }

    public void setId(String v) {
        this.id.set((Object)(v == null || v.isBlank() ? UUID.randomUUID().toString() : v));
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String v) {
        this.description.set((Object)(v == null ? "" : v));
    }

    public DoubleProperty targetValueProperty() {
        return this.targetValue;
    }

    public double getTargetValue() {
        return this.targetValue.get();
    }

    public void setTargetValue(double v) {
        this.targetValue.set(v);
        this.targetValueText.set((Object)Parameter.formatNumericText(v));
    }

    public StringProperty targetValueTextProperty() {
        return this.targetValueText;
    }

    public String getTargetValueText() {
        return (String)this.targetValueText.get();
    }

    public void setTargetValueText(String text) {
        String sanitized = Parameter.sanitizeNumberText(text);
        this.targetValueText.set((Object)sanitized);
        this.targetValue.set(Parameter.parseNumber(sanitized));
    }

    public DoubleProperty upperLimitProperty() {
        return this.upperLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit.get();
    }

    public void setUpperLimit(double v) {
        this.upperLimit.set(v);
        this.upperLimitText.set((Object)Parameter.formatNumericText(v));
    }

    public StringProperty upperLimitTextProperty() {
        return this.upperLimitText;
    }

    public String getUpperLimitText() {
        return (String)this.upperLimitText.get();
    }

    public void setUpperLimitText(String text) {
        String sanitized = Parameter.sanitizeNumberText(text);
        this.upperLimitText.set((Object)sanitized);
        this.upperLimit.set(Parameter.parseNumber(sanitized));
    }

    public DoubleProperty lowerLimitProperty() {
        return this.lowerLimit;
    }

    public double getLowerLimit() {
        return this.lowerLimit.get();
    }

    public void setLowerLimit(double v) {
        this.lowerLimit.set(v);
        this.lowerLimitText.set((Object)Parameter.formatNumericText(v));
    }

    public StringProperty lowerLimitTextProperty() {
        return this.lowerLimitText;
    }

    public String getLowerLimitText() {
        return (String)this.lowerLimitText.get();
    }

    public void setLowerLimitText(String text) {
        String sanitized = Parameter.sanitizeNumberText(text);
        this.lowerLimitText.set((Object)sanitized);
        this.lowerLimit.set(Parameter.parseNumber(sanitized));
    }

    public BooleanProperty attributeProperty() {
        return this.attribute;
    }

    public boolean isAttribute() {
        return this.attribute.get();
    }

    public void setAttribute(boolean v) {
        this.attribute.set(v);
    }

    public BooleanProperty criticalToSafetyProperty() {
        return this.criticalToSafety;
    }

    public boolean isCriticalToSafety() {
        return this.criticalToSafety.get();
    }

    public void setCriticalToSafety(boolean v) {
        this.criticalToSafety.set(v);
    }

    public BooleanProperty criticalToQualityProperty() {
        return this.criticalToQuality;
    }

    public boolean isCriticalToQuality() {
        return this.criticalToQuality.get();
    }

    public void setCriticalToQuality(boolean v) {
        this.criticalToQuality.set(v);
    }

    public BooleanProperty criticalToProcessProperty() {
        return this.criticalToProcess;
    }

    public boolean isCriticalToProcess() {
        return this.criticalToProcess.get();
    }

    public void setCriticalToProcess(boolean v) {
        this.criticalToProcess.set(v);
    }

    public String toString() {
        String d = this.getDescription();
        return d == null || d.isBlank() ? "(characteristic)" : d;
    }

    private static String sanitizeNumberText(String text) {
        if (text == null) {
            return "";
        }
        return text.trim();
    }

    private static double parseNumber(String text) {
        if (text == null || text.isBlank()) {
            return Double.NaN;
        }
        String normalized = text.replace(',', '.');
        try {
            return Double.parseDouble(normalized);
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    private static String formatNumericText(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return "";
        }
        String text = Double.toString(value);
        if (text.indexOf(69) >= 0 || text.indexOf(101) >= 0) {
            return text;
        }
        if (text.indexOf(46) >= 0) {
            while (text.endsWith("0")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }
}

