/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.processItem;

import com.qualidadeeprodutividade.processItem.Ishikawa;
import com.qualidadeeprodutividade.processItem.Parameter;
import com.qualidadeeprodutividade.processItem.ProcessCategory;
import com.qualidadeeprodutividade.processItem.ProcessType;
import com.qualidadeeprodutividade.processItem.ValueCategory;
import java.util.Objects;
import java.util.UUID;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ProcessItem {
    private final StringProperty id = new SimpleStringProperty((Object)this, "id", UUID.randomUUID().toString());
    private final StringProperty description = new SimpleStringProperty((Object)this, "description", "");
    private final StringProperty function = new SimpleStringProperty((Object)this, "function", "");
    private final ObjectProperty<ProcessType> type = new SimpleObjectProperty((Object)this, "type", (Object)ProcessType.OPERATION);
    private final ObjectProperty<Ishikawa> ishikawa = new SimpleObjectProperty((Object)this, "ishikawa", (Object)Ishikawa.METHOD);
    private final DoubleProperty time = new SimpleDoubleProperty((Object)this, "time", 0.0);
    private final DoubleProperty distance = new SimpleDoubleProperty((Object)this, "distance", 0.0);
    private final ObjectProperty<ProcessCategory> category = new SimpleObjectProperty((Object)this, "category", (Object)ProcessCategory.OPERATION);
    private final ObjectProperty<ValueCategory> valueCategory = new SimpleObjectProperty((Object)this, "valueCategory", (Object)ValueCategory.VA);
    private final ObservableList<ProcessItem> children = FXCollections.observableArrayList();
    private final ObservableList<Parameter> parameters = FXCollections.observableArrayList();

    public ProcessItem() {
    }

    public ProcessItem(String description, String function, ProcessType type, Ishikawa ishikawa) {
        this.setDescription(description);
        this.setFunction(function);
        this.setType(type == null ? ProcessType.OPERATION : type);
        this.setIshikawa(ishikawa == null ? Ishikawa.METHOD : ishikawa);
    }

    public StringProperty idProperty() {
        return this.id;
    }

    public String getId() {
        return (String)this.id.get();
    }

    public void setId(String v) {
        this.id.set((Object)(v == null || v.isBlank() ? UUID.randomUUID().toString() : v));
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String v) {
        this.description.set((Object)(v == null ? "" : v));
    }

    public StringProperty functionProperty() {
        return this.function;
    }

    public String getFunction() {
        return (String)this.function.get();
    }

    public void setFunction(String v) {
        this.function.set((Object)(v == null ? "" : v));
    }

    public ObjectProperty<ProcessType> typeProperty() {
        return this.type;
    }

    public ProcessType getType() {
        return (ProcessType)((Object)this.type.get());
    }

    public void setType(ProcessType v) {
        this.type.set((Object)v);
    }

    public ObjectProperty<Ishikawa> ishikawaProperty() {
        return this.ishikawa;
    }

    public Ishikawa getIshikawa() {
        return (Ishikawa)((Object)this.ishikawa.get());
    }

    public void setIshikawa(Ishikawa i) {
        this.ishikawa.set((Object)i);
    }

    public DoubleProperty timeProperty() {
        return this.time;
    }

    public double getTime() {
        return this.time.get();
    }

    public void setTime(double v) {
        this.time.set(v);
    }

    public DoubleProperty distanceProperty() {
        return this.distance;
    }

    public double getDistance() {
        return this.distance.get();
    }

    public void setDistance(double v) {
        this.distance.set(v);
    }

    public ObjectProperty<ProcessCategory> categoryProperty() {
        return this.category;
    }

    public ProcessCategory getCategory() {
        return (ProcessCategory)((Object)this.category.get());
    }

    public void setCategory(ProcessCategory c) {
        this.category.set((Object)c);
    }

    public ObjectProperty<ValueCategory> valueCategoryProperty() {
        return this.valueCategory;
    }

    public ValueCategory getValueCategory() {
        return (ValueCategory)((Object)this.valueCategory.get());
    }

    public void setValueCategory(ValueCategory vc) {
        this.valueCategory.set((Object)vc);
    }

    public ObservableList<ProcessItem> getChildren() {
        return this.children;
    }

    public void addChild(ProcessItem child) {
        if (child != null) {
            this.children.add((Object)child);
        }
    }

    public boolean removeChild(ProcessItem child) {
        return this.children.remove((Object)child);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public ObservableList<Parameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(Parameter parameter) {
        if (parameter != null) {
            this.parameters.add((Object)parameter);
        }
    }

    public boolean removeParameter(Parameter parameter) {
        return this.parameters.remove((Object)parameter);
    }

    public void clearParameter() {
        this.parameters.clear();
    }

    public String toString() {
        String d = this.getDescription();
        return d == null || d.isBlank() ? "(item)" : d;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcessItem)) {
            return false;
        }
        ProcessItem other = (ProcessItem)o;
        return Objects.equals(this.getId(), other.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }
}

