/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.processItem;

import com.qualidadeeprodutividade.processItem.Parameter;
import com.qualidadeeprodutividade.processItem.ProcessItem;

public final class ProcessStructureCloner {
    private ProcessStructureCloner() {
    }

    public static ProcessItem cloneProcessItem(ProcessItem original) {
        if (original == null) {
            return null;
        }
        ProcessItem copy = new ProcessItem();
        copy.setDescription(original.getDescription());
        copy.setFunction(original.getFunction());
        copy.setType(original.getType());
        copy.setIshikawa(original.getIshikawa());
        copy.setTime(original.getTime());
        copy.setDistance(original.getDistance());
        copy.setCategory(original.getCategory());
        copy.setValueCategory(original.getValueCategory());
        if (original.getParameters() != null) {
            original.getParameters().forEach(param -> {
                Parameter cloned = ProcessStructureCloner.cloneParameter(param);
                if (cloned != null) {
                    copy.addParameter(cloned);
                }
            });
        }
        if (original.getChildren() != null) {
            original.getChildren().forEach(child -> {
                ProcessItem cloned = ProcessStructureCloner.cloneProcessItem(child);
                if (cloned != null) {
                    copy.addChild(cloned);
                }
            });
        }
        return copy;
    }

    public static Parameter cloneParameter(Parameter original) {
        if (original == null) {
            return null;
        }
        Parameter copy = new Parameter();
        copy.setDescription(original.getDescription());
        copy.setTargetValue(original.getTargetValue());
        copy.setLowerLimit(original.getLowerLimit());
        copy.setUpperLimit(original.getUpperLimit());
        copy.setAttribute(original.isAttribute());
        copy.setCriticalToSafety(original.isCriticalToSafety());
        copy.setCriticalToQuality(original.isCriticalToQuality());
        copy.setCriticalToProcess(original.isCriticalToProcess());
        return copy;
    }
}

