/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.project;

import com.qualidadeeprodutividade.controlPlan.ControlPlan;
import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.fmea.Dfmea;
import com.qualidadeeprodutividade.fmea.Pfmea;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.project.ProjectStatus;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Project {
    private final StringProperty id = new SimpleStringProperty((Object)this, "id", UUID.randomUUID().toString());
    private final StringProperty name = new SimpleStringProperty((Object)this, "name", "Untitled Project");
    private final StringProperty description = new SimpleStringProperty((Object)this, "description", "");
    private final StringProperty projectLeader = new SimpleStringProperty((Object)this, "projectLeader", "");
    private final StringProperty projectTeam = new SimpleStringProperty((Object)this, "projectTeam", "");
    private final ObjectProperty<LocalDate> startDate = new SimpleObjectProperty((Object)this, "startDate", null);
    private final StringProperty plant = new SimpleStringProperty((Object)this, "plant", "");
    private final StringProperty plantLocation = new SimpleStringProperty((Object)this, "plantLocation", "");
    private final ObjectProperty<ProjectStatus> status = new SimpleObjectProperty((Object)this, "Status", (Object)ProjectStatus.PENDING_START);
    private final ObservableList<Item> productTrees = FXCollections.observableArrayList();
    private final ObservableList<ProcessItem> processTrees = FXCollections.observableArrayList();
    private final ObservableList<Dfmea> dfmeas = FXCollections.observableArrayList();
    private final ObservableList<Pfmea> pfmeas = FXCollections.observableArrayList();
    private final ObservableList<ControlPlan> controlPlans = FXCollections.observableArrayList();
    private final ObservableList<EightD> eightDReports = FXCollections.observableArrayList();

    public Project() {
    }

    public Project(String name) {
        this();
        this.setName(name);
    }

    public Project(String name, String description) {
        this(name);
        this.setDescription(description);
    }

    public StringProperty idProperty() {
        return this.id;
    }

    public String getId() {
        return (String)this.id.get();
    }

    public void setId(String v) {
        this.id.set((Object)(v == null || v.isBlank() ? UUID.randomUUID().toString() : v));
    }

    public final String getName() {
        return (String)this.name.get();
    }

    public final void setName(String v) {
        this.name.set((Object)v);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getDescription() {
        return (String)this.description.get();
    }

    public final void setDescription(String v) {
        this.description.set((Object)v);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    public final String getProjectLeader() {
        return (String)this.projectLeader.get();
    }

    public final void setProjectLeader(String v) {
        this.projectLeader.set((Object)v);
    }

    public final StringProperty projectLeaderProperty() {
        return this.projectLeader;
    }

    public final String getProjectTeam() {
        return (String)this.projectTeam.get();
    }

    public final void setProjectTeam(String v) {
        this.projectTeam.set((Object)v);
    }

    public final StringProperty projectTeamProperty() {
        return this.projectTeam;
    }

    public final LocalDate getStartDate() {
        return (LocalDate)this.startDate.get();
    }

    public final void setStartDate(LocalDate v) {
        this.startDate.set((Object)v);
    }

    public final ObjectProperty<LocalDate> startDateProperty() {
        return this.startDate;
    }

    public final String getPlant() {
        return (String)this.plant.get();
    }

    public final void setPlant(String v) {
        this.plant.set((Object)v);
    }

    public final StringProperty plantProperty() {
        return this.plant;
    }

    public final String getPlantLocation() {
        return (String)this.plantLocation.get();
    }

    public final void setPlantLocation(String v) {
        this.plantLocation.set((Object)v);
    }

    public final StringProperty plantLocationProperty() {
        return this.plantLocation;
    }

    public final ObjectProperty<ProjectStatus> statusProperty() {
        return this.status;
    }

    public final ProjectStatus getStatus() {
        return (ProjectStatus)((Object)this.status.get());
    }

    public final void setStatus(ProjectStatus value) {
        this.status.set((Object)value);
    }

    public String toString() {
        return "Project: " + this.getName();
    }

    public ObservableList<Item> getProductTrees() {
        return this.productTrees;
    }

    public void addProductTree(Item child) {
        if (child != null) {
            this.productTrees.add((Object)child);
        }
    }

    public boolean removeProductTree(Item child) {
        return this.productTrees.remove((Object)child);
    }

    public void clearProductTrees() {
        this.productTrees.clear();
    }

    public ObservableList<ProcessItem> getProcessTrees() {
        return this.processTrees;
    }

    public void addProcessTree(ProcessItem child) {
        if (child != null) {
            this.processTrees.add((Object)child);
        }
    }

    public boolean removeProcessTree(ProcessItem child) {
        return this.processTrees.remove((Object)child);
    }

    public void clearProcessTrees() {
        this.processTrees.clear();
    }

    public ObservableList<Dfmea> getDfmeas() {
        return this.dfmeas;
    }

    public void addDfmea(Dfmea child) {
        if (child != null) {
            this.dfmeas.add((Object)child);
        }
    }

    public boolean removeDfmea(Dfmea child) {
        return this.dfmeas.remove((Object)child);
    }

    public void clearDfmeas() {
        this.dfmeas.clear();
    }

    public ObservableList<Pfmea> getPfmeas() {
        return this.pfmeas;
    }

    public void addPfmea(Pfmea child) {
        if (child != null) {
            this.pfmeas.add((Object)child);
        }
    }

    public boolean removePfmea(Pfmea child) {
        return this.pfmeas.remove((Object)child);
    }

    public void clearPfmeas() {
        this.pfmeas.clear();
    }

    public ObservableList<ControlPlan> getControlPlans() {
        return this.controlPlans;
    }

    public void addControlPlan(ControlPlan child) {
        if (child != null) {
            this.controlPlans.add((Object)child);
        }
    }

    public boolean removeControlPlan(ControlPlan child) {
        return this.controlPlans.remove((Object)child);
    }

    public void clearControlPlan() {
        this.controlPlans.clear();
    }

    public ObservableList<EightD> getEightDReports() {
        return this.eightDReports;
    }

    public void addEightDReport(EightD report) {
        if (report != null) {
            this.eightDReports.add((Object)report);
        }
    }

    public boolean removeEightDReport(EightD report) {
        return this.eightDReports.remove((Object)report);
    }

    public void clearEightDReports() {
        this.eightDReports.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        return Objects.equals(this.getId(), other.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }
}

