---
title: "CoreTools(TM) User Guide"
subtitle: Quality Tools Management
output:
  pdf_document:
    toc: true
    toc_depth: '3'
  html_document:
    toc: true
    toc_depth: 3
    number_sections: true
    toc_float:
      collapsed: false
      smooth_scroll: true
    theme: cosmo
  word_document:
    toc: true
    toc_depth: '3'
---

\newpage

![](CoreTools_Users_Guide_media/media/image_001.png)

# Introduction

CoreTools(TM) is a desktop application that unifies Product Trees, Process Trees, DFMEA, PFMEA, and Control Plans in one place. It supports engineering and quality teams with structure and function analysis, action tracking, document control, and traceability aligned with AIAG/VDA.

This guide covers every current feature, including the import/export options, exchange tools, search and editing helpers, and export customizations.

# Working With Projects

The main window shows your project tree on the left and a details table on the right. Sections group Product Trees, Process Trees, DFMEAs, PFMEAs, and Control Plans. Double-click any document to open its dedicated window.

![The Main Window](CoreTools_Users_Guide_media/media/image_002.png)

- **Add/duplicate/delete items**: Use the plus and X icons beside each section header or right-click any document for insert, duplicate, and delete.
- **Details table**: Select the project or a document to edit its header fields directly in the table (project owner, confidentiality, dates, etc.).
- **Unsaved changes**: An asterisk in the window title indicates pending changes. A lock file prevents two users from editing the same project simultaneously.

## File Menu

- **New/Open/Save/Save As/Close/Quit**: Standard project lifecycle actions (XML files).
- **Export logo...**: Set a default or custom logo (PNG/JPG) reused by all PDF/Excel exports.
- **Quit** prompts to save if there are pending changes.

## Data Menu

- **Import from Excel...**: Reads a multi-sheet workbook (`ProductTree`, `ProcessTree`, `DFMEA`, `PFMEA`, `ControlPlan`). Rows are created or updated using natural keys; a `.import-report.txt` is saved beside the workbook.
- **Export import template**: Generates a ready-to-fill Excel template with the expected sheet names and columns.
- **Import documents...**: Opens a drag-and-drop window to copy entire Product Trees, Process Trees, DFMEAs, PFMEAs, and Control Plans from another project file into the current one.

## Help Menu

- **Help (F1)**: Opens this guide.
- **About (F10)**: Version, credits, and website links.

\newpage

# Product Trees

Double-click a Product Tree to open the Product Tree Manager. The left pane is the structure; the right pane edits properties. The bottom status bar shows the path to the selected node.

![Product Tree editor](CoreTools_Users_Guide_media/media/image_003.png)

## Tree Editor

- **Add System/Part/Characteristic**: Toolbar buttons create children that respect structural rules (products/systems host systems or parts; any can host characteristics).
- **Drag-and-drop**: Reorder or re-parent nodes (systems/parts/characteristics) within allowed hierarchies. Invalid targets are blocked.
- **Search and navigate**: Type in the search box and use **Next** to jump through matches.
- **Collapse/Expand**: One-click controls expand or collapse the entire tree.
- **Context menu**: Right-click nodes to insert siblings, duplicate, or delete.

## Structure Exchange

Use **Structure Exchange** to copy systems, parts, or characteristics from any product in the project into the current one via drag-and-drop between two trees.

![Structure Exchange drag-and-drop](CoreTools_Users_Guide_media/media/image_004.png)

## Tree Viewer

An interactive viewer tab renders the product tree for quick exploration and presentations.

![Product Tree viewer](CoreTools_Users_Guide_media/media/image_005.png)

## Product Requirements

Track requirements per product/system/part:

- Editable columns for description, specification, tolerance, customer importance, and automatically normalized percentage weights.
- Add, remove, or duplicate requirements with toolbar buttons.
- Importance percentages recalculate when rows change.

![Product requirements table](CoreTools_Users_Guide_media/media/image_006.png)

## Saving

Use **Save** to persist edits or **Save & Exit** to close the window after saving.

\newpage

# Process Trees

The Process Tree Manager uses a tree table so you can edit hierarchy and process details side by side.

![Process Tree editor](CoreTools_Users_Guide_media/media/image_007.png)

## Tree Editor

- **Add Operation/Activity/Parameter**: Buttons enable only when the selection supports that child type.
- **Columns**: Description, Function, Type (Process/Operation/Activity), Ishikawa, Category, Value-added flag, Time, Distance, plus parameter-specific fields (Target, Upper/Lower, Attribute, CTS/CTQ/CTP).
- **Drag-and-drop**: Reorder or re-parent operations, activities, and parameters with hierarchy validation.
- **Search and navigate**: Incremental search with **Next** to cycle through hits.
- **Context menu**: Insert, duplicate, or delete the selected row.
- **Collapse/Expand**: Buttons to toggle the full tree.

## Process Exchange

Copy operations, activities, or parameters between processes in the same project using the Process Exchange window (drag-and-drop between two trees).

![Process Exchange](CoreTools_Users_Guide_media/media/image_008.png)

## Flowchart

Switch to the **Flowchart** tab to view the process as a flow-style diagram in an embedded viewer.

![Process flowchart](CoreTools_Users_Guide_media/media/image_009.png)

## Saving

Save changes or Save & Exit from the toolbar.

\newpage

# DFMEA

Open a DFMEA from the project tree. A left-side tab bar separates Header, Failure Chains, Summary, Tree Chart, and Revision Control.

![DFMEA window](CoreTools_Users_Guide_media/media/image_010.png)

## Header

Edit company, engineering location, customer/product, model year/platform, subject, dates, team, ID number, design responsibility, and confidentiality level. Fields are bound to the project details table as well.

## Failure Chains

The table follows the AIAG/VDA 7-step layout with these capabilities:

- **Columns**: Change Authorization, Structure Analysis (Higher/Focus/Lower), Function Analysis, Failure Effect/Mode/Cause, Prevention & Detection controls, Severity/Occurrence/Detection, Action Priority (auto from S/O/D), RPN, Filter Code, Preventive/Detection actions, Responsible, Target/Completion dates, Status, Action Taken evidence, Current S/O/D and AP, and Remarks.
- **Add/Delete/Insert/Duplicate** rows via toolbar or right-click.
- **Keyboard**: Enter to edit, Ctrl+Enter to commit, Insert to add, Delete to clear cells, Ctrl+Z to undo (per-table undo stack).
- **Search**: Search box with **Next** highlights matching rows; selected hits are styled.
- **@mentions**: Type `@` in structure/function columns to pull names/functions from the Product Tree.
- **Copy/Paste**: Table clipboard helper supports pasting blocks from spreadsheets and clears cells with Delete.
- **Automatic calculations**: Action Priority recalculates when Severity/Occurrence/Detection change; RPN multiplies S/O/D. Current S/O/D/AP track post-action risk.
- **DFMEA Tables**: Quick access to severity/occurrence/detection reference tables.
- **Path-aware suggestions**: Mention menu groups higher/focus/lower elements to keep structure consistent.
- **Saved state**: Save or Save & Exit from the top toolbar.

![DFMEA failure chains](CoreTools_Users_Guide_media/media/image_011.png)

## Summary

Charts and a critical actions grid auto-refresh from the table:

- Action Priority (before/after) pie charts.
- Status counts bar chart.
- Severity, Occurrence, and Detection distributions.
- Critical Actions table filtered to open/pending items with focus element, failure mode, actions, status, responsible, and targets.

![DFMEA summary charts](CoreTools_Users_Guide_media/media/image_012.png)

## DFMEA Tree Chart

Interactive fault-tree-style view with color-coded Action Priority:

- Expand/collapse nodes, fit to window, and search to highlight nodes.
- Colors reflect the most critical AP category in each branch.

![DFMEA tree chart](CoreTools_Users_Guide_media/media/image_013.png)

## Revision Control

Track revisions with number, date, author, description, and approval status. Use Add/Edit/Approve/Delete controls; the latest approved revision is used on exports.

![Revision control](CoreTools_Users_Guide_media/media/image_014.png)

## Export

- **PDF or Excel**: Choose the format when exporting. File names are suggested from the subject and last approved revision.
- **Custom logos**: Uses the logo set in File > Export logo.

![PDF Export](CoreTools_Users_Guide_media/media/image_015.png)

\newpage

# PFMEA

PFMEA mirrors DFMEA but references process structures.

![PFMEA window](CoreTools_Users_Guide_media/media/image_016.png)

## Header

Fields for company, plant location, customer, model year/platform, subject, dates, team, PFMEA ID, process responsibility, and confidentiality level.

## Failure Chains

- Same editing tools as DFMEA: add/delete/duplicate, search with highlighting, @mentions (pulling process elements/parameters), copy/paste, undo, and keyboard shortcuts.
- Columns match the AIAG/VDA form, with structure/function/failure/risk/optimization sections, Action Priority, RPN, filter code, actions, responsibilities, dates, current S/O/D/AP, and remarks.
- Action Priority and RPN compute automatically from S/O/D.

## Summary, Tree Chart, Revision Control, and Export

Identical to DFMEA: charts, critical actions list, interactive tree chart, revision tracking, and export to PDF or Excel with your preferred logo.

\newpage

# Control Plans

Open a Control Plan from the project tree to manage header data and control chains.

![Control Plan window](CoreTools_Users_Guide_media/media/image_017.png)

## Header

Enter control plan level, plan/part numbers, part name/description, organization/plant/code, key contact, core team, approvals (organization, supplier, customer engineering/quality), and originated/revision dates.

## Control Chains

- **Columns**: Part/Process number, Process/Operation description, Machine/Tool, Product and Process characteristics, CTS/CTQ/CTP flags, Attribute flag, Limits and Target, Measurement technique, Sample size/frequency, Control method, Reaction plan, and an item number column.
- **Toolbar**: Add or delete rows, search with **Next**, keyboard hints (Enter to edit, Ctrl+Enter to commit).
- **Context menu**: Row-level actions mirror the toolbar.

## Revision Control

Track revisions with add/edit/approve/delete controls; latest approved revision is used in exports.

## Export

Export to PDF or Excel; logos follow the File > Export logo selection.

\newpage

# Importing and Exchanging Data

## Excel Import

- Workbook sheets recognized by name: `ProductTree`, `ProcessTree`, `DFMEA`, `PFMEA`, `ControlPlan`.
- Natural keys avoid duplicates (e.g., part number/description for Product Tree, issue number or failure mode+cause for FMEAs, row number or process+characteristic for Control Plans).
- Dates and enums are parsed case-insensitively; missing fields use defaults where applicable.
- An import report (`<file>.import-report.txt`) lists created/updated rows and errors.
- Use **Data > Export import template** to generate a correctly structured workbook with sample rows.

## Document Import

**Data > Import documents...** opens a two-pane drag-and-drop tool:

- Select a source project XML.
- Drag documents (Product/Process Trees, DFMEAs, PFMEAs, Control Plans) into the destination list.
- Save to commit copies into the current project.

## Structure/Process Exchange

- **Product**: Copy systems, parts, or characteristics between products in the same project.
- **Process**: Copy operations, activities, or parameters between processes in the same project.
- Drag-and-drop between origin and destination trees; changes mark the project as dirty until saved.

\newpage

# Exporting

- Choose PDF or Excel when exporting DFMEA, PFMEA, or Control Plans.
- Suggested file names use the document subject and last approved revision.
- Logos follow the preference set via **File > Export logo...** (default CoreTools logo or your custom image).
- Exports include current header data, revision header, and tables, plus charts for FMEAs.

\newpage

# About CoreTools(TM)

CoreTools(TM) - Integrated Quality Tools for DFMEA / PFMEA / Control Plans  
Version: 1.0.0  
Copyright (c) 2025. All rights reserved.

**System requirements**

- Windows 10 or higher (64-bit)
- Bundled Java Runtime (no external JRE required)
- Minimum 4 GB RAM, ~170 MB disk space

This software is free to use and redistribute. No license key is required. Modification or resale without authorization is prohibited. Provided "as is" without warranty of any kind.

**Contact**

- Fernando Ferrari Fernandes - fernando.fernandes@qualidadeprodutividade.com
- Website: https://www.qualidadeprodutividade.com
